import 'dart:convert';

Respondatacuti respondatacutiFromJson(String str) =>
    Respondatacuti.fromJson(json.decode(str));

String respondatacutiToJson(Respondatacuti data) => json.encode(data.toJson());

class Respondatacuti {
  bool? success;
  String? message;
  Data? data;

  Respondatacuti({
    this.success,
    this.message,
    this.data,
  });

  factory Respondatacuti.fromJson(Map<String, dynamic> json) => Respondatacuti(
        success: json["success"],
        message: json["message"],
        data: json['data'] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data == null ? null : data!.toJson(),
      };
}

class Data {
  String? sisaCuti;
  String? cutiBerlakuHingga;
  String? periodeAwalCuti;
  String? periodeAkhirCuti;
  String? totalTambah;
  String? totalKurang;

  Data({
    this.sisaCuti,
    this.cutiBerlakuHingga,
    this.periodeAwalCuti,
    this.periodeAkhirCuti,
    this.totalTambah,
    this.totalKurang,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        sisaCuti: json["sisa_cuti"],
        cutiBerlakuHingga: json["berlaku_hingga"],
        periodeAwalCuti: json["periode_awal"],
        periodeAkhirCuti: json["periode_akhir"],
        totalTambah: json["total_tambah"],
        totalKurang: json["total_kurang"],
      );

  Map<String, dynamic> toJson() => {
        "sisa_cuti": sisaCuti,
        "berlaku_hingga": cutiBerlakuHingga,
        "periode_awal": periodeAwalCuti,
        "periode_akhir": periodeAkhirCuti,
        "total_tambah": totalTambah,
        "total_kurang": totalKurang,
      };
}
