import 'dart:convert';

NotifikasiAkunRespon dataNotifikasiAkunResponFromJson(String str) =>
    NotifikasiAkunRespon.fromJson(json.decode(str));

String dataNotifikasiAkunResponToJson(NotifikasiAkunRespon data) =>
    json.encode(data.toJson());

class NotifikasiAkunRespon {
  bool? success;
  String? message;
  List<DataNotifikasiAkun>? dataNotifikasiAkun;

  NotifikasiAkunRespon({this.success, this.message, this.dataNotifikasiAkun});

  NotifikasiAkunRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_notifikasi_akun'] != null) {
      dataNotifikasiAkun = <DataNotifikasiAkun>[];
      json['data_notifikasi_akun'].forEach((v) {
        dataNotifikasiAkun!.add(new DataNotifikasiAkun.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataNotifikasiAkun != null) {
      data['data_notifikasi_akun'] =
          this.dataNotifikasiAkun!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataNotifikasiAkun {
  String? idNotif;
  String? idKaryawan;
  String? idCompany;
  String? id;
  String? route;
  String? messageNotifikasi;
  String? flagBaca;
  String? jenis;
  String? action;
  String? statusAction;
  String? statusPengajuan;
  String? menu;

  DataNotifikasiAkun(
      {this.idNotif,
      this.idKaryawan,
      this.idCompany,
      this.id,
      this.route,
      this.messageNotifikasi,
      this.flagBaca,
      this.jenis,
      this.action,
      this.statusAction,
      this.statusPengajuan,
      this.menu});

  DataNotifikasiAkun.fromJson(Map<String, dynamic> json) {
    idNotif = json['id_notif'];
    idKaryawan = json['id_karyawan'];
    idCompany = json['id_company'];
    id = json['id'];
    route = json['route'];
    messageNotifikasi = json['message_notifikasi'];
    flagBaca = json['flag_baca'];
    jenis = json['jenis'];
    action = json['action'];
    statusAction = json['status_action'];
    statusPengajuan = json['status_pengajuan'];
    menu = json['menu'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_notif'] = this.idNotif;
    data['id_karyawan'] = this.idKaryawan;
    data['id_company'] = this.idCompany;
    data['id'] = this.id;
    data['route'] = this.route;
    data['message_notifikasi'] = this.messageNotifikasi;
    data['flag_baca'] = this.flagBaca;
    data['jenis'] = this.jenis;
    data['action'] = this.action;
    data['status_action'] = this.statusAction;
    data['status_pengajuan'] = this.statusPengajuan;
    data['menu'] = this.menu;
    return data;
  }
}
