import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'dart:convert';

DataPengalamanKerjaByIdRespon dataPengalamanKerjaByIdResponFromJson(String str) => DataPengalamanKerjaByIdRespon.fromJson(json.decode(str));

String dataPengalamanKerjaByIdResponToJson(DataPengalamanKerjaByIdRespon data) => json.encode(data.toJson());

class DataPengalamanKerjaByIdRespon {
  bool? success;
  String? message;
  List<DataDatapengalamankerjaById>? dataDatapengalamankerjaById;

  DataPengalamanKerjaByIdRespon(
      {this.success, this.message, this.dataDatapengalamankerjaById});

  DataPengalamanKerjaByIdRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_datapengalamankerja'] != null) {
      dataDatapengalamankerjaById = <DataDatapengalamankerjaById>[];
      json['data_datapengalamankerja'].forEach((v) {
        dataDatapengalamankerjaById!.add(new DataDatapengalamankerjaById.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatapengalamankerjaById != null) {
      data['data_datapengalamankerja'] =
          this.dataDatapengalamankerjaById!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataDatapengalamankerjaById {
  String? idRiwayatPekerjaan;
  String? idKaryawan;
  String? title;
  String? idCompany;
  String? namaPerusahaan;
  String? jenisPerusahaan;
  String? jabatan;
  JenisData? kota;
  JenisData? provinsi;
  String? alamatPerusahaan;
  String? tglMasuk;
  String? tglKeluar;
  String? alasanBerhenti;
  String? file;

  DataDatapengalamankerjaById(
      {this.idRiwayatPekerjaan,
        this.idKaryawan,
        this.title,
        this.idCompany,
        this.namaPerusahaan,
        this.jenisPerusahaan,
        this.jabatan,
        this.kota,
        this.provinsi,
        this.alamatPerusahaan,
        this.tglMasuk,
        this.tglKeluar,
        this.alasanBerhenti,
        this.file});

  DataDatapengalamankerjaById.fromJson(Map<String, dynamic> json) {
    idRiwayatPekerjaan = json['id_riwayat_pekerjaan'];
    idKaryawan = json['id_karyawan'];
    title = json['title'];
    idCompany = json['id_company'];
    namaPerusahaan = json['nama_perusahaan'];
    jenisPerusahaan = json['jenis_perusahaan'];
    jabatan = json['jabatan'];
    kota = json['kota'] != null ? new JenisData.fromJson(json['kota']) : null;
    provinsi =
    json['provinsi'] != null ? new JenisData.fromJson(json['provinsi']) : null;
    alamatPerusahaan = json['alamat_perusahaan'];
    tglMasuk = json['tgl_masuk'];
    tglKeluar = json['tgl_keluar'];
    alasanBerhenti = json['alasan_berhenti'];
    file = json['file'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_riwayat_pekerjaan'] = this.idRiwayatPekerjaan;
    data['id_karyawan'] = this.idKaryawan;
    data['title'] = this.title;
    data['id_company'] = this.idCompany;
    data['nama_perusahaan'] = this.namaPerusahaan;
    data['jenis_perusahaan'] = this.jenisPerusahaan;
    data['jabatan'] = this.jabatan;
    if (this.kota != null) {
      data['kota'] = this.kota!.toJson();
    }
    if (this.provinsi != null) {
      data['provinsi'] = this.provinsi!.toJson();
    }
    data['alamat_perusahaan'] = this.alamatPerusahaan;
    data['tgl_masuk'] = this.tglMasuk;
    data['tgl_keluar'] = this.tglKeluar;
    data['alasan_berhenti'] = this.alasanBerhenti;
    data['file'] = this.file;
    return data;
  }
}