import 'dart:convert';

DataPendidikanRespon dataPendidikanResponFromJson(String str) => DataPendidikanRespon.fromJson(json.decode(str));

String dataPendidikanResponToJson(DataPendidikanRespon data) => json.encode(data.toJson());

class DataPendidikanRespon {
  bool? success;
  String? message;
  List<DataDatapendidikan>? dataDatapendidikan;

  DataPendidikanRespon({this.success, this.message, this.dataDatapendidikan});

  DataPendidikanRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_datapendidikan'] != null) {
      dataDatapendidikan = <DataDatapendidikan>[];
      json['data_datapendidikan'].forEach((v) {
        dataDatapendidikan!.add(new DataDatapendidikan.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatapendidikan != null) {
      data['data_datapendidikan'] =
          this.dataDatapendidikan!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataDatapendidikan {
  String? idPendidikan;
  String? idKaryawan;
  String? namaSekolah;
  String? jenjang;
  String? jurusan;
  String? lulusanAsal;
  String? gelar;
  String? tahunMasuk;
  String? tahunLulus;
  String? ijazah;
  String? transkrip;
  String? idCompany;
  String? statusPengajuan;
  String? colorStatusPengajuan;
  bool? buttonRevisi;
  String? ketRevisi;

  DataDatapendidikan(
      {this.idPendidikan,
        this.idKaryawan,
        this.namaSekolah,
        this.jenjang,
        this.jurusan,
        this.lulusanAsal,
        this.gelar,
        this.tahunMasuk,
        this.tahunLulus,
        this.ijazah,
        this.transkrip,
        this.idCompany,
        this.statusPengajuan,
        this.colorStatusPengajuan,
        this.buttonRevisi,
        this.ketRevisi});

  DataDatapendidikan.fromJson(Map<String, dynamic> json) {
    idPendidikan = json['id_pendidikan'];
    idKaryawan = json['id_karyawan'];
    namaSekolah = json['nama_sekolah'];
    jenjang = json['jenjang'];
    jurusan = json['jurusan'];
    lulusanAsal = json['lulusan_asal'];
    gelar = json['gelar'];
    tahunMasuk = json['tahun_masuk'];
    tahunLulus = json['tahun_lulus'];
    ijazah = json['ijazah'];
    transkrip = json['transkrip'];
    idCompany = json['id_company'];
    statusPengajuan = json['status_pengajuan'];
    colorStatusPengajuan = json['color_status_pengajuan'];
    buttonRevisi = json['button_revisi'];
    ketRevisi = json['ket_revisi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_pendidikan'] = this.idPendidikan;
    data['id_karyawan'] = this.idKaryawan;
    data['nama_sekolah'] = this.namaSekolah;
    data['jenjang'] = this.jenjang;
    data['jurusan'] = this.jurusan;
    data['lulusan_asal'] = this.lulusanAsal;
    data['gelar'] = this.gelar;
    data['tahun_masuk'] = this.tahunMasuk;
    data['tahun_lulus'] = this.tahunLulus;
    data['ijazah'] = this.ijazah;
    data['transkrip'] = this.transkrip;
    data['id_company'] = this.idCompany;
    data['status_pengajuan'] = this.statusPengajuan;
    data['color_status_pengajuan'] = this.colorStatusPengajuan;
    data['button_revisi'] = this.buttonRevisi;
    data['ket_revisi'] = this.ketRevisi;
    return data;
  }
}



