import 'dart:convert';

DataKeluargaRespon dataKeluargaResponFromJson(String str) => DataKeluargaRespon.fromJson(json.decode(str));

String dataKeluargaResponToJson(DataKeluargaRespon data) => json.encode(data.toJson());

class DataKeluargaRespon {
  bool? success;
  String? message;
  List<DataDatakeluarga>? dataDatakeluarga;

  DataKeluargaRespon({this.success, this.message, this.dataDatakeluarga});

  DataKeluargaRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_datakeluarga'] != null) {
      dataDatakeluarga = <DataDatakeluarga>[];
      json['data_datakeluarga'].forEach((v) {
        dataDatakeluarga!.add(new DataDatakeluarga.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatakeluarga != null) {
      data['data_datakeluarga'] =
          this.dataDatakeluarga!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataDatakeluarga {
  String? idKeluarga;
  String? idKaryawan;
  String? nik;
  String? namaLengkap;
  String? tempatLahir;
  String? tglLahir;
  String? jenisKelamin;
  String? agama;
  String? telepon;
  String? pekerjaan;
  String? hubKeluarga;
  String? statusPerkawinan;
  String? noBpjs;
  String? pendidikanTerakhir;
  String? tanggalPerkawinan;
  String? status;
  String? idCompany;
  String? statusPengajuan;
  String? colorStatusPengajuan;
  bool? buttonRevisi;
  String? ketRevisi;

  DataDatakeluarga(
      {this.idKeluarga,
        this.idKaryawan,
        this.nik,
        this.namaLengkap,
        this.tempatLahir,
        this.tglLahir,
        this.jenisKelamin,
        this.agama,
        this.telepon,
        this.pekerjaan,
        this.hubKeluarga,
        this.statusPerkawinan,
        this.noBpjs,
        this.pendidikanTerakhir,
        this.tanggalPerkawinan,
        this.status,
        this.idCompany,
        this.statusPengajuan,
        this.colorStatusPengajuan,
        this.buttonRevisi,
        this.ketRevisi});

  DataDatakeluarga.fromJson(Map<String, dynamic> json) {
    idKeluarga = json['id_keluarga'];
    idKaryawan = json['id_karyawan'];
    nik = json['nik'];
    namaLengkap = json['nama_lengkap'];
    tempatLahir = json['tempat_lahir'];
    tglLahir = json['tgl_lahir'];
    jenisKelamin = json['jenis_kelamin'];
    agama = json['agama'];
    telepon = json['telepon'];
    pekerjaan = json['pekerjaan'];
    hubKeluarga = json['hub_keluarga'];
    statusPerkawinan = json['status_perkawinan'];
    noBpjs = json['no_bpjs'];
    pendidikanTerakhir = json['pendidikan_terakhir'];
    tanggalPerkawinan = json['tanggal_perkawinan'];
    status = json['status'];
    idCompany = json['id_company'];
    statusPengajuan = json['status_pengajuan'];
    colorStatusPengajuan = json['color_status_pengajuan'];
    buttonRevisi = json['button_revisi'];
    ketRevisi = json['ket_revisi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_keluarga'] = this.idKeluarga;
    data['id_karyawan'] = this.idKaryawan;
    data['nik'] = this.nik;
    data['nama_lengkap'] = this.namaLengkap;
    data['tempat_lahir'] = this.tempatLahir;
    data['tgl_lahir'] = this.tglLahir;
    data['jenis_kelamin'] = this.jenisKelamin;
    data['agama'] = this.agama;
    data['telepon'] = this.telepon;
    data['pekerjaan'] = this.pekerjaan;
    data['hub_keluarga'] = this.hubKeluarga;
    data['status_perkawinan'] = this.statusPerkawinan;
    data['no_bpjs'] = this.noBpjs;
    data['pendidikan_terakhir'] = this.pendidikanTerakhir;
    data['tanggal_perkawinan'] = this.tanggalPerkawinan;
    data['status'] = this.status;
    data['id_company'] = this.idCompany;
    data['status_pengajuan'] = this.statusPengajuan;
    data['color_status_pengajuan'] = this.colorStatusPengajuan;
    data['button_revisi'] = this.buttonRevisi;
    data['ket_revisi'] = this.ketRevisi;
    return data;
  }
}

