import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:absenkuv3/Repository/Service/dashboardApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapHadirEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapHadirEvent extends SummaryRekapHadirEvent {
  ModelFilter? modelFilter;
  getSummaryRekapHadirEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapHadirState {
  DataSummary? data;
}

class getSummaryRekapHadirSuccessState extends SummaryRekapHadirState {
  getSummaryRekapHadirSuccessState(
      SummaryRekapHadirEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressRekapHadirState extends SummaryRekapHadirState {}

class SummaryErrorState extends SummaryRekapHadirState {}

class SummaryRekapHadirBloc
    extends Bloc<SummaryRekapHadirEvent, SummaryRekapHadirState> {
  SummaryRekapHadirState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapHadirBloc(SummaryRekapHadirState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapHadirState> mapEventToState(
      SummaryRekapHadirEvent event) async* {
    if (event is getSummaryRekapHadirEvent) {
      yield SummaryProgressRekapHadirState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/hadir');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapHadirSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
