import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:absenkuv3/Repository/Service/dashboardApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapAlpaEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapAlpaEvent extends SummaryRekapAlpaEvent {
  ModelFilter? modelFilter;
  getSummaryRekapAlpaEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapAlpaState {
  DataSummary? data;
}

class getSummaryRekapAlpaSuccessState extends SummaryRekapAlpaState {
  getSummaryRekapAlpaSuccessState(
      SummaryRekapAlpaEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressRekapAlpaState extends SummaryRekapAlpaState {}

class SummaryErrorState extends SummaryRekapAlpaState {}

class SummaryRekapAlpaBloc
    extends Bloc<SummaryRekapAlpaEvent, SummaryRekapAlpaState> {
  SummaryRekapAlpaState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapAlpaBloc(SummaryRekapAlpaState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapAlpaState> mapEventToState(
      SummaryRekapAlpaEvent event) async* {
    if (event is getSummaryRekapAlpaEvent) {
      yield SummaryProgressRekapAlpaState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/alpa');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapAlpaSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
