import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/dashboardApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class HadirEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getHadirEvent extends HadirEvent {
  ModelFilter? modelFilter;
  getHadirEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class GetDataHadirDashboardEvent extends HadirEvent {
  GetDataHadirDashboardEvent(BuildContext _context) {
    context = _context;
  }
}

abstract class HadirState {
  DataSummary? data;
}

class getSummarySuccessState extends HadirState {
  getSummarySuccessState(HadirEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class getHadirDashboardSuccessState extends HadirState {
  getHadirDashboardSuccessState(HadirEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class HadirProgressState extends HadirState {}

class LoadMoreProgressState extends HadirState {
  LoadMoreProgressState(DataSummary _data) {
    data = _data;
  }
}

class HadirErrorState extends HadirState {}

class HadirBloc extends Bloc<HadirEvent, HadirState> {
  HadirState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  HadirBloc(HadirState initialState) : super(initialState);

  @override
  Stream<HadirState> mapEventToState(HadirEvent event) async* {
    if (event is GetDataHadirDashboardEvent) {
      yield HadirProgressState();
      SummaryRespon hadir = await DashboardApi().getHadir();
      if (hadir.success!) {
        listSummary = hadir.data;
        yield getHadirDashboardSuccessState(event, listSummary);
      } else {
        yield HadirErrorState();
      }
    }
  }
}
