import 'package:absenkuv3/Bloc/Badge/BadgeShiftBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Shift/TukarShiftDetailBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mPengajuanSaya.dart' as pengajuan;
import 'package:absenkuv3/Repository/Model/mShift.dart';
import 'package:absenkuv3/Repository/Model/mShiftTeman.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Model/mTukarShift.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/shiftApi.dart';
import 'package:absenkuv3/Repository/Service/tukarShiftApi.dart';
import 'package:absenkuv3/Bloc/CustomBloc.dart' as customFunction;
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/progress_dialog.dart';

abstract class TukarShiftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? tanggal;
  String? keyword;
  String? jenis;
}

class getListShiftTemanEvent extends TukarShiftEvent {
  getListShiftTemanEvent(BuildContext _context, String _tanggal, String _keyword, String _jenis) {
    context = _context;
    tanggal = _tanggal;
    keyword = _keyword;
    jenis   = _jenis;
  }
}

class pengajuanTukarShift extends TukarShiftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GlobalKey<FormState>? formKey;
  ModelTukarShift model;
  ModelFilter? modelFilter;
  String? pageAction;
  pengajuanTukarShift(this.model, this.context, this.scaffoldKey, this.formKey,
      this.modelFilter, this.pageAction);
}

class LoadMoreListShiftTemanEvent extends TukarShiftEvent {
  late ScrollController scrollController;
  LoadMoreListShiftTemanEvent(
      BuildContext _context,
      String _tanggal,
      String _keyword,
      String _jenis,
      ScrollController _scrollController) {
    context = _context;
    tanggal = _tanggal;
    keyword = _keyword;
    jenis   = _jenis;
    scrollController = _scrollController;
  }
}

class getListShiftSendiriEvent extends TukarShiftEvent {
  getListShiftSendiriEvent(BuildContext _context, String _tanggal) {
    context = _context;
    tanggal = _tanggal;
  }
}

class getListShiftRawEvent extends TukarShiftEvent {
  getListShiftRawEvent(BuildContext _context, String _tanggal) {
    context = _context;
    tanggal = _tanggal;
  }
}

class getListPengajuanSayaEvent extends TukarShiftEvent {
  getListPengajuanSayaEvent(BuildContext _context) {
    context = _context;
  }
}

class getListPermintaanEvent extends TukarShiftEvent {
  getListPermintaanEvent(BuildContext _context) {
    context = _context;
  }
}

class getListHistoryEvent extends TukarShiftEvent {
  getListHistoryEvent(BuildContext _context) {
    context = _context;
  }
}

class loadMoreTukarShiftSayaEvent extends TukarShiftEvent {
  late ScrollController scrollController;
  loadMoreTukarShiftSayaEvent(
      BuildContext _context,
      GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

class loadMoreTukarShiftTemanEvent extends TukarShiftEvent {
  late ScrollController scrollController;
  loadMoreTukarShiftTemanEvent(
      BuildContext _context,
      GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class TukarShiftState {
  List<DataShift>? data;
  List<pengajuan.DataPengajuanSaya>? datumPengajuan;
  List<Datum>? datum;
  DataShift? dataAktivitas;
}

class setujui extends TukarShiftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idPengajuan;
  String pageActionFrom;
  String konteks;
  setujui(
      this.idPengajuan, this.context, this.scaffoldKey, this.pageActionFrom, this.konteks);
}

class tolak extends TukarShiftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idPengajuan;
  String pageActionFrom;
  String konteks;
  tolak(this.idPengajuan, this.context, this.scaffoldKey, this.pageActionFrom, this.konteks);
}

class getListTukarShiftSuccessState extends TukarShiftState {
  getListTukarShiftSuccessState(
      TukarShiftEvent _event, List<DataShift>? _data) {
    data = _data;
  }
}

class getListShiftTemanSuccessState extends TukarShiftState {
  getListShiftTemanSuccessState(TukarShiftEvent _event, List<Datum>? _datum) {
    datum = _datum;
  }
}

class getListPengajuanSayaSuccessState extends TukarShiftState {
  getListPengajuanSayaSuccessState(TukarShiftEvent _event,
      List<pengajuan.DataPengajuanSaya>? _datumPengajuan) {
    datumPengajuan = _datumPengajuan;
  }
}

class TukarShiftProgressState extends TukarShiftState {}

class LoadMoreShiftTemanProgressState extends TukarShiftState {
  LoadMoreShiftTemanProgressState(List<Datum>? _datum) {
    datum = _datum;
  }
}

class LoadMoreTukarShiftProgressState extends TukarShiftState {
  LoadMoreTukarShiftProgressState(List<Datum>? _datum) {
    datum = _datum;
  }
}

class LoadMorePengajuanTukarShiftSayaProgressState extends TukarShiftState {
  LoadMorePengajuanTukarShiftSayaProgressState(
      List<pengajuan.DataPengajuanSaya>? _datumPengajuan) {
    datumPengajuan = _datumPengajuan;
  }
}

class LoadMorePengajuanTukarShiftTamanProgressState extends TukarShiftState {
  LoadMorePengajuanTukarShiftTamanProgressState(
      List<pengajuan.DataPengajuanSaya>? _datumPengajuan) {
    datumPengajuan = _datumPengajuan;
  }
}

class getListPengajuanTemanSuccessState extends TukarShiftState {
  getListPengajuanTemanSuccessState(TukarShiftEvent _event,
      List<pengajuan.DataPengajuanSaya>? _datumPengajuan) {
    datumPengajuan = _datumPengajuan;
  }
}

class LoadMoreTukarShiftTemanProgressState extends TukarShiftState {
  LoadMoreTukarShiftTemanProgressState(List<Datum>? _datum) {
    datum = _datum;
  }
}

class TukarShiftErrorState extends TukarShiftState {}

class TukarShiftBloc extends Bloc<TukarShiftEvent, TukarShiftState> {
  TukarShiftState? initialState;
  List<DataShift>? listShift;

  List<Datum>? listDatum;
  List<pengajuan.DataPengajuanSaya>? listPengajuan;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  TukarShiftBloc(TukarShiftState initialState) : super(initialState);

  @override
  Stream<TukarShiftState> mapEventToState(TukarShiftEvent event) async* {
    if (event is getListShiftTemanEvent) {
      print('masuk teman bloc');
      limit = ServerInfo.limit;
      offset = 0;
      yield TukarShiftProgressState();
      ShiftTeman shiftTeman = await TukarShiftApi().getTeman(event.tanggal!, event.keyword!, offset, limit);
      if (shiftTeman.success!) {
        listDatum = shiftTeman.data;
        yield getListShiftTemanSuccessState(event, listDatum);
      } else
        yield TukarShiftErrorState();
    } else if (event is LoadMoreListShiftTemanEvent) {
      debugPrint('eventloadmore');
      if (event.scrollController.offset >= event.scrollController.position.maxScrollExtent && !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreShiftTemanProgressState(listDatum!);
        ShiftTeman shiftTeman = await TukarShiftApi().getTeman(event.tanggal!, event.keyword!, offset, limit);
        if (shiftTeman.success!) {
          listDatum!.addAll(shiftTeman.data!);
        }
        yield getListShiftTemanSuccessState(event, listDatum);
      }
    } else if (event is getListShiftSendiriEvent) {
      print('masuk shift sendiri bloc');
      offset = 0;
      yield TukarShiftProgressState();
      ShiftTeman shiftSendiri = await TukarShiftApi().getSendiri(event.tanggal!);
      if (shiftSendiri.success!) {
        listDatum = shiftSendiri.data;
        yield getListShiftTemanSuccessState(event, listDatum);
      } else
        yield TukarShiftErrorState();
    }
    // else if (event is getListShiftRawEvent) {
    //   print('masuk raw bloc');
    //   offset = 0;
    //   yield TukarShiftProgressState();
    //   ShiftTeman shiftTeman = await TukarShiftApi().getShift(event.tanggal!);
    //   if (shiftTeman.success!) {
    //     listDatum = shiftTeman.data;
    //     yield getListShiftTemanSuccessState(event, listDatum);
    //   } else
    //     yield TukarShiftErrorState();
    // }
    else if (event is getListPengajuanSayaEvent) {
      print('masuk pengajuan saya bloc');
      offset = 0;
      yield TukarShiftProgressState();
      pengajuan.PengajuanSaya pengajuanSaya = await TukarShiftApi().getDataPengajuanSaya(limit,offset);
      if (pengajuanSaya.success!) {
        listPengajuan = pengajuanSaya.data!;
        yield getListPengajuanSayaSuccessState(event, listPengajuan);
      } else
        yield TukarShiftErrorState();
    } else if (event is loadMoreTukarShiftSayaEvent) {
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMorePengajuanTukarShiftSayaProgressState(listPengajuan);
        pengajuan.PengajuanSaya pengajuanSaya =
        await TukarShiftApi().getDataPengajuanSaya(limit,offset);
        if (pengajuanSaya.success!) {
          listPengajuan!.addAll(pengajuanSaya.data!);
        }
        yield getListPengajuanSayaSuccessState(event, listPengajuan);
      }
    } else if (event is getListPermintaanEvent) {
      print('masuk permintaan bloc');
      offset = 0;
      yield TukarShiftProgressState();
      pengajuan.PengajuanSaya pengajuanSaya = await TukarShiftApi().getDataPermintan(limit,offset);
      print(pengajuanSaya.data);
      if (pengajuanSaya.success!) {
        listPengajuan = pengajuanSaya.data!;
        yield getListPengajuanTemanSuccessState(event, listPengajuan);
      } else
        yield TukarShiftErrorState();
    } else if (event is loadMoreTukarShiftTemanEvent) {
      debugPrint('loadmoreteman');
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMorePengajuanTukarShiftTamanProgressState(listPengajuan);
        pengajuan.PengajuanSaya pengajuanSaya =
        await TukarShiftApi().getDataPermintan(limit,offset);
        if (pengajuanSaya.success!) {
          listPengajuan!.addAll(pengajuanSaya.data!);
        }
        yield getListPengajuanTemanSuccessState(event, listPengajuan);
      }
    } else if (event is getListHistoryEvent) {
      print('masuk history bloc');
      offset = 0;
      yield TukarShiftProgressState();
      pengajuan.PengajuanSaya pengajuanSaya =
      await TukarShiftApi().getDataHistory();
      print(pengajuanSaya.data);
      if (pengajuanSaya.success!) {
        listPengajuan = pengajuanSaya.data!;
        yield getListPengajuanSayaSuccessState(event, listPengajuan);
      } else
        yield TukarShiftErrorState();
    } else if (event is setujui) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await TukarShiftApi().setujui(event.idPengajuan!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        BlocProvider.of<BadgeShiftBloc>(event.context!).add(GetBadgeShift(event.context!, event.scaffoldKey!));
        BlocProvider.of<TukarShiftDetailBloc>(event.context!).add(GetListTukarShiftDetailEvent(event.context!,event.idPengajuan, event.konteks));
        BlocProvider.of<TukarShiftBloc>(event.context!)
            .add(getListPermintaanEvent(event.context!));
      });
    } else if (event is tolak) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await TukarShiftApi().tolak(event.idPengajuan!);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        BlocProvider.of<BadgeShiftBloc>(event.context!).add(GetBadgeShift(event.context!, event.scaffoldKey!));
        BlocProvider.of<TukarShiftDetailBloc>(event.context!).add(GetListTukarShiftDetailEvent(event.context!,event.idPengajuan, event.konteks));
        BlocProvider.of<TukarShiftBloc>(event.context!).add(getListPermintaanEvent(event.context!));
      });
    }else if (event is pengajuanTukarShift) {
      // BlocProvider.of<NavigatorBloc>(event.context!)
      //     .add(NavigatePop(event.context));
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await TukarShiftApi().pengajuan(event.model);
      ProgressDialogDelayed.hide(pd);
      // showSnackBarDelayed(
      //     event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (event.pageAction == 'ShiftSaya') {
          customFunction.CustomPopUp.show(basicRespon.message, event.context,
              isDismissible: false, closeCustom: () {
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateToTukarShiftReplace(event.context!, 'shift_saya'));
              });
        } else {
          customFunction.CustomPopUp.show(basicRespon.message, event.context,
              isDismissible: false, closeCustom: () {
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateToTukarShiftReplace(event.context!, 'shift_teman'));
              });
        }
      } else {
        if (event.pageAction == 'ShiftSaya') {
          customFunction.CustomPopUp.show(basicRespon.message, event.context,
              isDismissible: false,
              icon: Icon(
                Icons.dangerous,
                color: Colors.red,
                size: 50,
              ),
              color: Colors.red, closeCustom: () {
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateToTukarShiftReplace(event.context!,'shift_saya'));
              });
        } else {
          customFunction.CustomPopUp.show(basicRespon.message, event.context,
              doublePop: true,
              isDismissible: false,
              icon: Icon(
                Icons.dangerous,
                color: Colors.red,
                size: 50,
              ),
              color: Colors.red, closeCustom: () {
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigatePop(event.context));
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigatePop(event.context));
              });
        }
      }
    }
  }
}
