import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Repository/Model/mTukarShift.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/shiftApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class ShiftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListShiftEvent extends ShiftEvent {
  ModelFilter modelFilter;
  getListShiftEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class loadMoreEvent extends ShiftEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class ShiftState {
  List<DataShift>? data;
  DataShift? dataAktivitas;
}

class getListShiftSuccessState extends ShiftState {
  getListShiftSuccessState(ShiftEvent _event, List<DataShift>? _data) {
    data = _data;
  }
}

class pengajuanTukarShift extends ShiftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GlobalKey<FormState>? formKey;
  ModelTukarShift model;
  ModelFilter? modelFilter;
  String? pageAction;
  pengajuanTukarShift(this.model, this.context, this.scaffoldKey, this.formKey,
      this.modelFilter, this.pageAction);
}

class ShiftProgressState extends ShiftState {}

class LoadMoreProgressState extends ShiftState {
  LoadMoreProgressState(List<DataShift>? _data) {
    data = _data;
  }
}

class ShiftErrorState extends ShiftState {}

class DraftShiftErrorState extends ShiftState {}

class ShiftBloc extends Bloc<ShiftEvent, ShiftState> {
  ShiftState? initialState;
  List<DataShift>? listShift;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  ShiftBloc(ShiftState initialState) : super(initialState);

  @override
  Stream<ShiftState> mapEventToState(ShiftEvent event) async* {
    if (event is getListShiftEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield ShiftProgressState();
      ShiftRespon shiftRespon =
      await ShiftApi().getDataShift(offset, modelFilter);
      if (shiftRespon.success!) {
        listShift = shiftRespon.data;
        yield getListShiftSuccessState(event, listShift);
      } else
        yield ShiftErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >= event.scrollController.position.maxScrollExtent && !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listShift);
        ShiftRespon shiftRespon = await ShiftApi().getDataShift(offset, modelFilter);
        if (shiftRespon.success!) {
          listShift!.addAll(shiftRespon.data!);
        }
        yield getListShiftSuccessState(event, listShift);
      }
    }
  }
}
