import 'package:absenkuv3/Repository/Model/SalesActivity/mTotalKanban.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class TotalKambanEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getTotalKambanEvent extends TotalKambanEvent {
  String? idTahapanM;
  ModelFilter? modelFilter;
  getTotalKambanEvent(BuildContext _context, this.idTahapanM, this.modelFilter) {
    context = _context;
  }
}

abstract class TotalKambanState {
  DataTotal? dataTotalKanban;
}

class getTotalKambanSuccessState extends TotalKambanState {
  getTotalKambanSuccessState(DataTotal _dataTotal) {
    dataTotalKanban = _dataTotal;
  }
}

class TotalKambanProgressState extends TotalKambanState {}

class TotalKambanErrorState extends TotalKambanState {}

class TotalKambanBloc extends Bloc<TotalKambanEvent, TotalKambanState> {

  TotalKambanBloc(TotalKambanState initialState) : super(initialState);

  @override
  Stream<TotalKambanState> mapEventToState(TotalKambanEvent event) async* {
    if (event is getTotalKambanEvent) {
      yield TotalKambanProgressState();
      TotalKanbanRespon dataKanban = await SalesActivityApi().getTotalKanban(event.idTahapanM, event.modelFilter!);
      if (dataKanban.success!) {
        yield getTotalKambanSuccessState(dataKanban.dataTotal!);
      } else
        yield TotalKambanErrorState();
    }
  }
}
