import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mTotalDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DataLayananDetailByIdEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getDataLayananDetailByIdEvent extends DataLayananDetailByIdEvent {
  String? idPipelineMain;
  getDataLayananDetailByIdEvent(BuildContext _context, this.idPipelineMain) {
    context = _context;
  }
}

abstract class DataLayananDetailByIdState {
  TotalDataLayananDetail? totalDataLayananDetail;
  List<Layanan>? dataLayananDetail;
}

class getDataLayananDetailByIdSuccessState extends DataLayananDetailByIdState {
  getDataLayananDetailByIdSuccessState(List<Layanan> _dataTotal, TotalDataLayananDetail? _totalDataLayananDetail) {
    dataLayananDetail = _dataTotal;
    totalDataLayananDetail = _totalDataLayananDetail;
  }
}

class DataLayananDetailByIdProgressState extends DataLayananDetailByIdState {}

class DataLayananDetailByIdErrorState extends DataLayananDetailByIdState {}

class DataLayananDetailByIdBloc extends Bloc<DataLayananDetailByIdEvent, DataLayananDetailByIdState> {
  List<Layanan>? dataLayananDetail;

  DataLayananDetailByIdBloc(DataLayananDetailByIdState initialState) : super(initialState);

  @override
  Stream<DataLayananDetailByIdState> mapEventToState(DataLayananDetailByIdEvent event) async* {
    if (event is getDataLayananDetailByIdEvent) {
      yield DataLayananDetailByIdProgressState();
      DataLayananDetailRespon _dataLayananDetail = await SalesActivityApi().getDataLayananDetailById(event.idPipelineMain);
      if (_dataLayananDetail.success!) {
        dataLayananDetail = _dataLayananDetail.dataLayananDetail;
        yield getDataLayananDetailByIdSuccessState(dataLayananDetail!, _dataLayananDetail.totalDataLayananDetail);
      } else
        yield DataLayananDetailByIdErrorState();
    }
  }
}
