import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DetailKanbanSalesBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/KambanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalKambanBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class ApproverEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class ApproverState {}

class SetujuiKanbanEvent extends ApproverEvent {
  DataKanban dataKanban;
  String idPipelineMain;
  String idPipelineMainLog;
  String idTahapanM;
  ModelFilter? modelFilter;
  String pageActionFrom;
  SetujuiKanbanEvent(BuildContext _context, this.dataKanban, this.idPipelineMain, this.idPipelineMainLog, this.idTahapanM, this.modelFilter, this.pageActionFrom) {
    context = _context;
  }
}

class TolakKanbanEvent extends ApproverEvent {
  String pageSelected;
  DataKanban dataKanban;
  String idPipelineMain;
  String idPipelineMainLog;
  String idTahapanM;
  String jenisTahapan;
  ModelFilter? modelFilter;
  String pageActionFrom;
  TolakKanbanEvent(BuildContext _context, this.pageSelected, this.dataKanban, this.idPipelineMain, this.idPipelineMainLog, this.idTahapanM, this.jenisTahapan, this.modelFilter, this.pageActionFrom) {
    context = _context;
  }
}

class TolakKanbanFromDailyEvent extends ApproverEvent {
  String pageSelected;
  String idPipelineMain;
  String idPipelineMainLog;
  String idTahapanM;
  String jenisTahapan;
  String pageActionFrom;
  TolakKanbanFromDailyEvent(BuildContext _context, this.pageSelected, this.idPipelineMain, this.idPipelineMainLog, this.idTahapanM, this.jenisTahapan, this.pageActionFrom) {
    context = _context;
  }
}

class SetujuiKanbanFromDailyEvent extends ApproverEvent {
  String idPipelineMain;
  String idPipelineMainLog;
  String idTahapanM;
  String pageActionFrom;
  SetujuiKanbanFromDailyEvent(BuildContext _context, this.idPipelineMain, this.idPipelineMainLog, this.idTahapanM, this.pageActionFrom) {
    context = _context;
  }
}

class TolakSuccessState extends ApproverState {
  BasicRespon? basicRespon;
  GlobalKey<ScaffoldState>? scaffoldKey;
  DataKanban? dataKanban;
  TolakSuccessState(this.basicRespon, this.scaffoldKey, this.dataKanban) {

  }
}

class SetujuiSuccessState extends ApproverState {
  BasicRespon? basicRespon;
  GlobalKey<ScaffoldState>? scaffoldKey;
  DataKanban? dataKanban;
  SetujuiSuccessState(this.basicRespon, this.scaffoldKey, this.dataKanban) {

  }
}

class ApproverProgressState extends ApproverState {}

// class SetujuiFailedState extends ApproverState {
//   String? message;
//   GlobalKey<ScaffoldState>? scaffoldKey;
//   SetujuiFailedState(this.message, this.scaffoldKey) {
//
//   }
// }

class ApproverBloc extends Bloc<ApproverEvent, ApproverState> {
  ApproverBloc(ApproverState initialState) : super(initialState);

  @override
  Stream<ApproverState> mapEventToState(ApproverEvent event) async* {
    if (event is SetujuiKanbanEvent) {
      yield ApproverProgressState();
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SalesActivityApi().setujuiKanban(event.idPipelineMain, event.idPipelineMainLog);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if(basicRespon.success!){
        if (event.pageActionFrom == 'detail'){
          event.dataKanban.button!.buttonApprove = false;
          event.dataKanban.button!.buttonTolak = false;
          yield SetujuiSuccessState(basicRespon, event.scaffoldKey, event.dataKanban);
        }
        Future.delayed(Duration(milliseconds: 600)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          if (event.pageActionFrom == 'list_data'){
            BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
            BlocProvider.of<KambanBloc>(event.context!)
                .add(getListDataKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
          }
          else if (event.pageActionFrom == 'detail') {
            print("masuk sini mas bos");
            // BlocProvider.of<NavigatorBloc>(event.context!)
            //     .add(NavigatePop(event.context));
            // BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
            // BlocProvider.of<KambanBloc>(event.context!)
            //     .add(getListDataKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
          }
        });
      }
    }
    else if (event is TolakKanbanEvent) {
      yield ApproverProgressState();
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SalesActivityApi().tolakKanban(event.idPipelineMain, event.idPipelineMainLog, event.idTahapanM, event.jenisTahapan);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if(basicRespon.success!){
        if (event.pageActionFrom == 'detail'){
          event.dataKanban.button!.buttonApprove = false;
          event.dataKanban.button!.buttonTolak = false;
          if(event.dataKanban.tahapanSebelumId != ""){
            event.dataKanban.idTahapanM = event.dataKanban.tahapanSebelumId;
          }
          yield TolakSuccessState(basicRespon, event.scaffoldKey, event.dataKanban);
        }
        Future.delayed(Duration(milliseconds: 600)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          if (event.pageActionFrom == 'list_data'){
            BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
            BlocProvider.of<KambanBloc>(event.context!)
                .add(getListDataKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
          }
          else if (event.pageActionFrom == 'detail') {
            // BlocProvider.of<NavigatorBloc>(event.context!)
            //     .add(NavigatePop(event.context));
            //


            // BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
            // BlocProvider.of<KambanBloc>(event.context!)
            //     .add(getListDataKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
            // Navigator.pop(event.context!, ['refresh', event.idTahapanM]);
            // BlocProvider.of<NavigatorBloc>(event.context!)
            //     .add(NavigateToDetailSalesActivityPage(event.context!, [event.dataKanban, event.pageSelected, 'refresh', event.idTahapanM]));
          }
        });
      }
    }

    else if (event is TolakKanbanFromDailyEvent) {
      yield ApproverProgressState();
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SalesActivityApi().tolakKanban(event.idPipelineMain, event.idPipelineMainLog, event.idTahapanM, event.jenisTahapan);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if(basicRespon.success!){
        if (event.pageActionFrom == 'list_data'){
          Future.delayed(Duration(milliseconds: 600)).then((value) {
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigatePop(event.context));
            // BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
            // BlocProvider.of<KambanBloc>(event.context!)
            //     .add(getListDataKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
          });
        }else{
          Future.delayed(Duration(milliseconds: 600)).then((value) {
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigatePop(event.context));
            BlocProvider.of<DetailKanbanSalesBloc>(event.context!).add(getDataDetailKanbanSalesEvent(event.context!, event.idPipelineMain, event.idPipelineMainLog));
          });
          yield TolakSuccessState(basicRespon, event.scaffoldKey, null);
        }
      }
    }

    if (event is SetujuiKanbanFromDailyEvent) {
      yield ApproverProgressState();
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SalesActivityApi().setujuiKanban(event.idPipelineMain, event.idPipelineMainLog);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if(basicRespon.success!){
        if (event.pageActionFrom == 'list_data'){
          Future.delayed(Duration(milliseconds: 600)).then((value) {
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigatePop(event.context));
            // BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
            // BlocProvider.of<KambanBloc>(event.context!)
            //     .add(getListDataKambanEvent(event.context!, event.idTahapanM, event.modelFilter));
          });
        }
        else if (event.pageActionFrom == 'detail') {
          Future.delayed(Duration(milliseconds: 600)).then((value) {
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigatePop(event.context));
            BlocProvider.of<DetailKanbanSalesBloc>(event.context!).add(getDataDetailKanbanSalesEvent(event.context!, event.idPipelineMain, event.idPipelineMainLog));
          });
          yield SetujuiSuccessState(basicRespon, event.scaffoldKey, null);
        }

      }
    }
  }
}
