import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Repository/Service/reimbursementApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

abstract class ReimbursementSayaEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetListReimbursementEvent extends ReimbursementSayaEvent{
  ModelFilter? modelFilter;
  GetListReimbursementEvent(BuildContext? _context, this.modelFilter){
    context = _context;
  }
}

class LoadMoreEvent extends ReimbursementSayaEvent{
  late ScrollController scrollController;
  LoadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController){
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class ReimbursementSayaState{
  List<DataReimbursement>? data;
  DataReimbursement? dataReimbusement;
}

class GetListReimbursementSuccessState extends ReimbursementSayaState{
  GetListReimbursementSuccessState(ReimbursementSayaEvent _event, List<DataReimbursement>? _data){
    data = _data;
  }
}

class ReimbursementProgressState extends ReimbursementSayaState{}

class LoadMoreProgressState extends ReimbursementSayaState{
  LoadMoreProgressState(List<DataReimbursement>? _data){
    data = _data;
  }
}

class ReimbursementErrorState extends ReimbursementSayaState{}

class ReimbursementSayaBloc extends Bloc<ReimbursementSayaEvent, ReimbursementSayaState>{
  final dateFormat = new DateFormat('yyyy-MM');
  ReimbursementSayaState? initialState;
  List<DataReimbursement>? listReimbursement;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  ReimbursementSayaBloc(ReimbursementSayaState initialState) : super(initialState);

  @override
  Stream<ReimbursementSayaState> mapEventToState(ReimbursementSayaEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetListReimbursementEvent){
      offset = 0;
      modelFilter = event.modelFilter;
      yield ReimbursementProgressState();
      ReimbursementRespon reimbursementRespon = await ReimbursementApi().getDataReimbursementSaya(modelFilter, offset);
      if(reimbursementRespon.success!){
        listReimbursement = reimbursementRespon.data;
        yield GetListReimbursementSuccessState(event, listReimbursement);
      }
      else yield ReimbursementErrorState();
    }
    else if(event is LoadMoreEvent){
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listReimbursement);
        ReimbursementRespon reimbursementRespon = await ReimbursementApi().getDataReimbursementSaya(modelFilter, offset);
        if(reimbursementRespon.success!){
          listReimbursement!.addAll(reimbursementRespon.data!);
        }
        yield GetListReimbursementSuccessState(event, listReimbursement);
      }
    }
  }
}