import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/reimbursementApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';
import '../NavigatorBloc.dart';

abstract class ReimbursementItemEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetListReimbursementItemEvent extends ReimbursementItemEvent {
  GetListReimbursementItemEvent(BuildContext? _context) {
    context = _context;
  }
}

class TambahReimbursementItemEvent extends ReimbursementItemEvent {
  GlobalKey<FormState> formKey;
  ListItemTemp listItemTemp;
  TambahReimbursementItemEvent(BuildContext _context,
      GlobalKey<ScaffoldState> _scaffoldKey, this.formKey, this.listItemTemp) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class EditReimbursementItemEvent extends ReimbursementItemEvent {
  GlobalKey<FormState> formKey;
  ListItemTemp listItemTemp;
  EditReimbursementItemEvent(BuildContext _context,
      GlobalKey<ScaffoldState> _scaffoldKey, this.formKey, this.listItemTemp) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class PengajuanReimbursementEvent extends ReimbursementItemEvent {
  GlobalKey<FormState> formKey;
  String keterangan;
  PengajuanReimbursementEvent(BuildContext _context,
      GlobalKey<ScaffoldState> _scaffoldKey, this.formKey, this.keterangan) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class HapusReimbursementItemEvent extends ReimbursementItemEvent {
  String? idItempTemp;
  HapusReimbursementItemEvent(BuildContext _context,
      GlobalKey<ScaffoldState> _scaffoldKey, this.idItempTemp) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

abstract class ReimbursementItemState {
  DataReimbursementItemTemp? data;
  DataReimbursementItemTemp? dataReimbusement;
}

class GetListReimbursementItemSuccessState extends ReimbursementItemState {
  GetListReimbursementItemSuccessState(
      ReimbursementItemEvent _event, DataReimbursementItemTemp? _data) {
    data = _data;
  }
}

class ReimbursementProgressState extends ReimbursementItemState {}

class LoadMoreProgressState extends ReimbursementItemState {
  LoadMoreProgressState(DataReimbursementItemTemp _data) {
    data = _data;
  }
}

class ReimbursementErrorState extends ReimbursementItemState {}

class ReimbursementItemBloc
    extends Bloc<ReimbursementItemEvent, ReimbursementItemState> {
  ReimbursementItemState? initialState;
  DataReimbursementItemTemp? dataReimbursementItem;
  int offset = 0;
  int limit = ServerInfo.limit;

  ReimbursementItemBloc(ReimbursementItemState initialState)
      : super(initialState);

  @override
  Stream<ReimbursementItemState> mapEventToState(
      ReimbursementItemEvent event) async* {
    if (event is GetListReimbursementItemEvent) {
      offset = 0;
      yield ReimbursementProgressState();
      ReimbursementItemTempRespon reimbursementItemTempRespon =
          await ReimbursementApi().getDataReimbursementItemTemp(offset);
      if (reimbursementItemTempRespon.success!) {
        dataReimbursementItem = reimbursementItemTempRespon.data;
        yield GetListReimbursementItemSuccessState(
            event, dataReimbursementItem);
      } else
        yield ReimbursementErrorState();
    } else if (event is TambahReimbursementItemEvent) {
      if (event.formKey.currentState!.validate()) {
        ProgressDialog pd = ProgressDialog(context: event.context);
        ProgressDialogDelayed.show(pd, isDismissible: false);
        BasicRespon basicRespon =
            await ReimbursementApi().tambahItemTemp(event.listItemTemp);
        ProgressDialogDelayed.hide(pd);
        showSnackBarDelayed(
            event.scaffoldKey, basicRespon.message, event.context);
        if (basicRespon.success!) {
          Future.delayed(Duration(milliseconds: 2000)).then((value) {
            Navigator.pop(event.context!, null);
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigateRemoveToMainReimbursement(event.context!));
          });
        }
      }
    } else if (event is EditReimbursementItemEvent) {
      if (event.formKey.currentState!.validate()) {
        ProgressDialog pd = ProgressDialog(context: event.context);
        ProgressDialogDelayed.show(pd, isDismissible: false);
        BasicRespon basicRespon =
            await ReimbursementApi().editItemTemp(event.listItemTemp);
        ProgressDialogDelayed.hide(pd);
        showSnackBarDelayed(
            event.scaffoldKey, basicRespon.message, event.context);
        if (basicRespon.success!) {
          Future.delayed(Duration(milliseconds: 2000)).then((value) {
            Navigator.pop(event.context!, null);
          });
        }
      }
    } else if (event is PengajuanReimbursementEvent) {
      if (event.formKey.currentState!.validate()) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        ProgressDialog pd = ProgressDialog(context: event.context);
        Future.delayed(Duration(milliseconds: 200)).then((value) {
          ProgressDialogDelayed.show(pd, isDismissible: false);
        });

        BasicRespon basicRespon =
            await ReimbursementApi().pengajuanReimbursement(event.keterangan);
        ProgressDialogDelayed.hide(pd);
        showSnackBarDelayed(
            event.scaffoldKey, basicRespon.message, event.context);
        if (basicRespon.success!) {
          Future.delayed(Duration(milliseconds: 2000)).then((value) {
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigateRemoveToMainReimbursement(event.context!));
          });
        }
      }
    } else if (event is HapusReimbursementItemEvent) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon =
          await ReimbursementApi().hapusItemTemp(event.idItempTemp);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        BlocProvider.of<ReimbursementItemBloc>(event.context!)
            .add(GetListReimbursementItemEvent(event.context));
      }
    }
  }
}
