import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Repository/Service/reimbursementApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

abstract class ReimbursementAdminFinanceEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetListReimbursementEvent extends ReimbursementAdminFinanceEvent {
  ModelFilter? modelFilter;
  GetListReimbursementEvent(BuildContext? _context, this.modelFilter) {
    context = _context;
  }
}

class LoadMoreEvent extends ReimbursementAdminFinanceEvent {
  late ScrollController scrollController;
  LoadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class ReimbursementAdminFinanceState {
  List<DataReimbursement>? data;
  DataReimbursement? dataReimbusement;
}

class GetListReimbursementSuccessState extends ReimbursementAdminFinanceState {
  GetListReimbursementSuccessState(
      ReimbursementAdminFinanceEvent _event, List<DataReimbursement>? _data) {
    data = _data;
  }
}

class ReimbursementAdminProgressState extends ReimbursementAdminFinanceState {}

class LoadMoreProgressState extends ReimbursementAdminFinanceState {
  LoadMoreProgressState(List<DataReimbursement>? _data) {
    data = _data;
  }
}

class ReimbursementErrorState extends ReimbursementAdminFinanceState {}

class ReimbursementAdminFinanceBloc extends Bloc<ReimbursementAdminFinanceEvent,
    ReimbursementAdminFinanceState> {
  final dateFormat = new DateFormat('yyyy-MM');
  ReimbursementAdminFinanceState? initialState;
  List<DataReimbursement>? listReimbursement;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  ReimbursementAdminFinanceBloc(ReimbursementAdminFinanceState initialState)
      : super(initialState);

  @override
  Stream<ReimbursementAdminFinanceState> mapEventToState(
      ReimbursementAdminFinanceEvent event) async* {
    if (event is GetListReimbursementEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield ReimbursementAdminProgressState();
      ReimbursementRespon reimbursementRespon = await ReimbursementApi()
          .getDataReimbursementAdminPengajuan(modelFilter, offset);
      if (reimbursementRespon.success!) {
        listReimbursement = reimbursementRespon.data;
        yield GetListReimbursementSuccessState(event, listReimbursement);
      } else
        yield ReimbursementErrorState();
    } else if (event is LoadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listReimbursement);
        ReimbursementRespon reimbursementRespon = await ReimbursementApi()
            .getDataReimbursementAdminPengajuan(modelFilter, offset);
        if (reimbursementRespon.success!) {
          listReimbursement!.addAll(reimbursementRespon.data!);
        }
        yield GetListReimbursementSuccessState(event, listReimbursement);
      }
    }
  }
}
