import 'package:absenkuv3/Bloc/Page/PageReimbursementBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementAdminFinanceBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/reimbursementApi.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementItemBloc.dart'
    as reimbursementItemBloc;
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementKaryawanBloc.dart'
    as karyawan;
import '../../Repository/Model/mLogin.dart';
import '../../Repository/sharedPreference.dart';
import '../../UI/Modul/Reimbursement/halamanPengajuanReimbursement.dart';
import '../../UI/Modul/Reimbursement/halamanReimbursementAdminPengajuan.dart';
import '../../UI/Modul/Reimbursement/halamanReimbursementKaryawan.dart';
import '../../UI/Modul/Reimbursement/halamanReimbursementSaya.dart';
import 'ReimbursementSayaBloc.dart';

abstract class CekakunReimbursementEvent {
  BuildContext? context;
}

class CekAkunAkunReimbursementEvent extends CekakunReimbursementEvent {
  // PageReimbursementModel? redaksional;
  // CekAkunAkunReimbursementEvent(BuildContext? _context, PageReimbursementModel? _redaksional) {
  CekAkunAkunReimbursementEvent(BuildContext? _context) {
    context = _context;
    // redaksional = _redaksional;
  }
}

abstract class CekakunReimbursementState {
  bool? status;
  int? countTabView;
  List<Widget> listTab = [];
  List<Widget> listTabView = [];
}

class CekAkunAkunReimbursementState extends CekakunReimbursementState {
  CekAkunAkunReimbursementState(bool? _status, int? _countTabView,
      List<Widget> _listTab, List<Widget> _listTabView) {
    status = _status;
    countTabView = _countTabView;
    listTab = _listTab;
    listTabView = _listTabView;
  }
}

class LoadingCekAkunReimbursementState extends CekakunReimbursementState {}

class CekAkunReimbursementProgressState extends CekakunReimbursementState {}

class GantiStatusError extends CekakunReimbursementState {}

class CekAkunReimbursementBloc
    extends Bloc<CekakunReimbursementEvent, CekakunReimbursementState> {
  String? status;
  CekAkunReimbursementBloc(CekakunReimbursementState initialState)
      : super(initialState);

  @override
  Stream<CekakunReimbursementState> mapEventToState(
      CekakunReimbursementEvent event) async* {
    if (event is CekAkunAkunReimbursementEvent) {
      PageReimbursementModel? redaksional;
      PengaturanBahasa().reimbursement().then((value) => redaksional = value);
      Future.delayed(Duration(seconds: 1));
      yield LoadingCekAkunReimbursementState();

      bool status = false;
      int countTabView = 2;
      List<Widget> listTabView = [
        MultiBlocProvider(providers: [
          BlocProvider<ReimbursementSayaBloc>(
            create: (context) {
              return ReimbursementSayaBloc(ReimbursementProgressState());
            },
          ),
          BlocProvider<reimbursementItemBloc.ReimbursementItemBloc>(
            create: (context) {
              return reimbursementItemBloc.ReimbursementItemBloc(
                  reimbursementItemBloc.ReimbursementProgressState());
            },
          ),
          BlocProvider<PageReimbursementBloc>(
            create: (context) {
              return PageReimbursementBloc(PageReimbursementGetProgress());
            },
          )
        ], child: HalamanPengajuanReimbursement()),
        BlocProvider<ReimbursementSayaBloc>(
          create: (BuildContext context) {
            return ReimbursementSayaBloc(ReimbursementProgressState());
          },
          child: HalamanReimbursementSaya(),
        ),
      ];

      LoginRespon data = await sharedPreferences().getUserData();
      if (data.dataLogin!.level != 3) {
        countTabView = 3;
        listTabView.add(BlocProvider<karyawan.ReimbursementKaryawanBloc>(
          create: (BuildContext context) {
            return karyawan.ReimbursementKaryawanBloc(
                karyawan.ReimbursementProgressState());
          },
          child: HalamanReimbursementKaryawan(),
        ));
      }

      BasicRespon cekDataReimbrus =
          await ReimbursementApi().cekAkunReimbursment();
      if (cekDataReimbrus.success!) {
        status = cekDataReimbrus.success!;
        countTabView = countTabView + 1;
        listTabView.add(BlocProvider<ReimbursementAdminFinanceBloc>(
          create: (BuildContext context) {
            return ReimbursementAdminFinanceBloc(
                ReimbursementAdminProgressState());
          },
          child: HalamanReimbursementAdminPengajuan(),
        ));
      }

      List<Widget> listTab = [
        SizedBox(
          width: countTabView < 4
              ? MediaQuery.of(event.context!).size.width / countTabView
              : null,
          child: Tab(
            text: "${redaksional!.menuReimbursement!.tabDraf} ",
          ),
        ),
        SizedBox(
          width: countTabView < 4
              ? MediaQuery.of(event.context!).size.width / countTabView
              : null,
          child: Tab(
            text: data.dataLogin!.level != 3 ? "${redaksional!.menuReimbursement!.tabPengajuanSaya}" : "${redaksional!.menuReimbursement!.tabPengajuan}",
          ),
        )
      ];

      if (data.dataLogin!.level != 3) {
        listTab.add(SizedBox(
          width: countTabView < 4
              ? MediaQuery.of(event.context!).size.width / countTabView
              : null,
          child: Tab(
            text: "${redaksional!.menuReimbursement!.tabPengajuanKaryawan}",
          ),
        ));
      }

      if (cekDataReimbrus.success!) {
        listTab.add(SizedBox(
          width: countTabView < 4
              ? MediaQuery.of(event.context!).size.width / countTabView
              : null,
          child: Tab(
            text: "${redaksional!.menuReimbursement!.tabApprovalAdmin}",
          ),
        ));
      }

      yield CekAkunAkunReimbursementState(
          status, countTabView, listTab, listTabView);
    }
  }
}

class CardItemReimbursementaBloc
    extends Bloc<CekakunReimbursementEvent, CekakunReimbursementState> {
  CardItemReimbursementaBloc(CekakunReimbursementState initialState)
      : super(initialState);

  @override
  Stream<CekakunReimbursementState> mapEventToState(
      CekakunReimbursementEvent event) {
    throw UnimplementedError();
  }
}
