import 'package:absenkuv3/Bloc/Badge/BadgeNotificationDashboardBloc.dart';
import 'package:absenkuv3/Bloc/BadgeNotifBloc.dart';
import 'package:absenkuv3/Bloc/Lembur/LemburBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementDetailBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementItemBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/KambanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalKambanBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import 'Reimbursement/CardItemBloc.dart';
import 'Reimbursement/ReimbursementKaryawanBloc.dart'
    as reimbursementKaryawanBloc;
import 'Reimbursement/ReimbursementSayaBloc.dart';

abstract class NavigatorAction {
  BuildContext? context;
  var data;
}

//NAVIGATE TO DASHBOARD
class NavigateRemoveToDashboard extends NavigatorAction {
  NavigateRemoveToDashboard(BuildContext? _context) {
    context = _context;
  }
}

//NAVIGATE TO LOGIN
class NavigateRemoveToLogin extends NavigatorAction {
  NavigateRemoveToLogin(BuildContext? _context) {
    context = _context;
  }
}
class NavigateRemoveToSplashScreen extends NavigatorAction {
  NavigateRemoveToSplashScreen(BuildContext? _context) {
    context = _context;
  }
}
class NavigateRemoveToLoginSSO extends NavigatorAction {
  NavigateRemoveToLoginSSO(BuildContext? _context) {
    context = _context;
  }
}

//NAVIGATE TO ABSENSI
class NavigateToAbsensi extends NavigatorAction {
  NavigateToAbsensi(BuildContext _context) {
    context = _context;
  }
}

class NavigateToAbsensiReplace extends NavigatorAction {
  NavigateToAbsensiReplace(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO PENGAJUAN IZIN
class NavigateToPengajuanIzin extends NavigatorAction {
  NavigateToPengajuanIzin(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO LIST IZIN
class NavigateToListIzin extends NavigatorAction {
  NavigateToListIzin(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO LIST REKAP IZIN
class NavigateToListRekapIzin extends NavigatorAction {
  NavigateToListRekapIzin(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO DETAIL IZIN
class NavigateToDetailIzin extends NavigatorAction {
  NavigateToDetailIzin(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO DETAIL IMAGE CLICKED
class NavigateToDetailImageClicked extends NavigatorAction {
  NavigateToDetailImageClicked(BuildContext _context, String? _imageUrl) {
    context = _context;
    data = _imageUrl;
  }
}

//NAVIGATE TO DETAIL IMAGE CLICKED AKUN
class NavigateToDetailImageClickedAkun extends NavigatorAction {
  NavigateToDetailImageClickedAkun(BuildContext _context, String? _imageUrl) {
    context = _context;
    data = _imageUrl;
  }
}

//NAVIGATE TO CAMERA
class NavigateToCamera extends NavigatorAction {
  NavigateToCamera(BuildContext _context, String _title) {
    context = _context;
    data = _title;
  }
}

//NAVIGATE TO FACE RECOGNITION
class NavigateToFaceRecognition extends NavigatorAction {
  NavigateToFaceRecognition(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO FACE REGISTRATION
class NavigateToFaceRegistration extends NavigatorAction {
  NavigateToFaceRegistration(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO LIST REKAP ABSENSI
class NavigateToListRekapAbsensi extends NavigatorAction {
  NavigateToListRekapAbsensi(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO DETAIL LIST REKAP ABSENSI
class NavigateToDetailListRekapAbsensi extends NavigatorAction {
  NavigateToDetailListRekapAbsensi(BuildContext _context, List<String> _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO PENGAJUAN LEMBUR
class NavigateToPengajuanLembur extends NavigatorAction {
  NavigateToPengajuanLembur(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO LIST LEMBUR
class NavigateToListLembur extends NavigatorAction {
  NavigateToListLembur(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO LIST REKAP LEMBUR
class NavigateToListRekapLembur extends NavigatorAction {
  NavigateToListRekapLembur(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO DETAIL LEMBUR
class NavigateToDetailLembur extends NavigatorAction {
  NavigateToDetailLembur(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN AKUN
class NavigateToHalamanAkun extends NavigatorAction {
  NavigateToHalamanAkun(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO REPLACE HALAMAN AKUN
class NavigateToRepaceHalamanAkun extends NavigatorAction {
  NavigateToRepaceHalamanAkun(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN UBAH PASSWORD
class NavigateToUbahPassword extends NavigatorAction {
  NavigateToUbahPassword(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO PENGAJUAN AKTIVITAS
class NavigateToPengajuanAktivitas extends NavigatorAction {
  NavigateToPengajuanAktivitas(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO LIST AKTIVITAS
class NavigateToListAktivitas extends NavigatorAction {
  NavigateToListAktivitas(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO DETAIL AKTIVITAS
class NavigateToDetailAktivitas extends NavigatorAction {
  NavigateToDetailAktivitas(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO LIST BERITA
class NavigateToListBerita extends NavigatorAction {
  NavigateToListBerita(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO DETAIL BERITA
class NavigateToDetailBerita extends NavigatorAction {
  NavigateToDetailBerita(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO DETAIL PENGUMUMAN
class NavigateToDetailPengumuman extends NavigatorAction {
  NavigateToDetailPengumuman(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN SHIFT
class NavigateToShift extends NavigatorAction {
  NavigateToShift(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN TUKAR SHIFT
class NavigateToTukarShift extends NavigatorAction {
  NavigateToTukarShift(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO DETAIL SHIFT TEMAN
class NavigateToDetailShiftTeman extends NavigatorAction {
  NavigateToDetailShiftTeman(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO DETAIL SHIFT KARYAWAN
class NavigateToDetailShiftKaryawan extends NavigatorAction {
  NavigateToDetailShiftKaryawan(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO PENGAJUAN TUKAR SHIFT
// class NavigateToPengajuanTukarShift extends NavigatorAction {
//   NavigateToPengajuanTukarShift(BuildContext _context, var _data) {
//     context = _context;
//     data = _data;
//   }
// }

class NavigateToDetailTukarShift extends NavigatorAction {
  NavigateToDetailTukarShift(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN INFO GAJI
class NavigateToGaji extends NavigatorAction {
  NavigateToGaji(BuildContext? _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN SLIP GAJI
class NavigateToSlipGaji extends NavigatorAction {
  NavigateToSlipGaji(BuildContext? _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN MAIN REIMBURSEMENT
class NavigateToMainReimbursement extends NavigatorAction {
  NavigateToMainReimbursement(BuildContext _context) {
    context = _context;
  }
}

class NavigateToTukarShiftReplace extends NavigatorAction {
  NavigateToTukarShiftReplace(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN MAIN REIMBURSEMENT
class NavigateRemoveToMainReimbursement extends NavigatorAction {
  NavigateRemoveToMainReimbursement(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN MAIN REKAP REIMBURSEMENT
class NavigateToMainRekapReimbursement extends NavigatorAction {
  NavigateToMainRekapReimbursement(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO DETAIL REIMBURSEMENT
class NavigateToDetailReimbursement extends NavigatorAction {
  NavigateToDetailReimbursement(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO PENGAJUAN REIMBURSEMENT
class NavigateToPengajuanReimbursement extends NavigatorAction {
  NavigateToPengajuanReimbursement(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO TAMBAH ITEM PENGAJUAN REIMBURSEMENT
class NavigateToTambahItemPengajuanReimbursement extends NavigatorAction {
  NavigateToTambahItemPengajuanReimbursement(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO EDIT ITEM PENGAJUAN REIMBURSEMENT
class NavigateToEditItemPengajuanReimbursement extends NavigatorAction {
  NavigateToEditItemPengajuanReimbursement(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN REKAP KARYAWAN
class NavigateToRekapKaryawan extends NavigatorAction {
  NavigateToRekapKaryawan(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN DETAIL MAP
class NavigateToDetailMap extends NavigatorAction {
  NavigateToDetailMap(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToNotif extends NavigatorAction {
  NavigateToNotif(BuildContext _context) {
    context = _context;
  }
}

class NavigatePop extends NavigatorAction {
  NavigatePop(BuildContext? _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN DATA DIRI
class NavigateToHalamanDataDiri extends NavigatorAction {
  NavigateToHalamanDataDiri(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN EDIT DATA DIRI
class NavigateToHalamanEditDataDiri extends NavigatorAction {
  NavigateToHalamanEditDataDiri(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN EDIT DATA PENGAJUAN DATA DIRI
class NavigateToHalamanEditDataPengajuanDataDiri extends NavigatorAction {
  NavigateToHalamanEditDataPengajuanDataDiri(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO REPLACE HALAMAN DATA KELUARGA
class NavigateToReplaceHalamanDataKeluarga extends NavigatorAction {
  NavigateToReplaceHalamanDataKeluarga(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DATA KELUARGA
class NavigateToHalamanDataKeluarga extends NavigatorAction {
  NavigateToHalamanDataKeluarga(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN TAMBAH DATA KELUARGA
class NavigateToHalamanAddDataKeluarga extends NavigatorAction {
  NavigateToHalamanAddDataKeluarga(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN EDIT PENGAJUAN DATA KELUARGA
class NavigateToHalamanEditPengajuanDataKeluarga extends NavigatorAction {
  NavigateToHalamanEditPengajuanDataKeluarga(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN EDIT DATA KELUARGA
class NavigateToHalamanEditDataKeluarga extends NavigatorAction {
  NavigateToHalamanEditDataKeluarga(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO REPLACE HALAMAN DATA PENDIDIKAN
class NavigateToReplaceHalamanDataPendidikan extends NavigatorAction {
  NavigateToReplaceHalamanDataPendidikan(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DATA PENDIDIKAN
class NavigateToHalamanDataPendidikan extends NavigatorAction {
  NavigateToHalamanDataPendidikan(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN TAMBAH DATA PENDIDIKAN
class NavigateToHalamanAddDataPendidikan extends NavigatorAction {
  NavigateToHalamanAddDataPendidikan(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN EDIT PENGAJUAN DATA PENDIDIKAN
class NavigateToHalamanEditPengajuanDataPendidikan extends NavigatorAction {
  NavigateToHalamanEditPengajuanDataPendidikan(
      BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN EDIT DATA PENDIDIKAN
class NavigateToHalamanEditDataPendidikan extends NavigatorAction {
  NavigateToHalamanEditDataPendidikan(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO REPLACE HALAMAN DATA KELENGKAPAN FILE
class NavigateToReplaceHalamanDataKelengkapanFile extends NavigatorAction {
  NavigateToReplaceHalamanDataKelengkapanFile(
      BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DATA KELENGKAPAN FILE
class NavigateToHalamanDataKelengkapanFile extends NavigatorAction {
  NavigateToHalamanDataKelengkapanFile(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN TAMBAH DATA KELENGKAPAN FILE
class NavigateToHalamanAddDataKelengkapanFile extends NavigatorAction {
  NavigateToHalamanAddDataKelengkapanFile(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN EDIT PENGAJUAN DATA KELENGKAPAN FILE
class NavigateToHalamanEditPengajuanDataKelengkapanFile
    extends NavigatorAction {
  NavigateToHalamanEditPengajuanDataKelengkapanFile(
      BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN EDIT DATA KELENGKAPAN FILE
class NavigateToHalamanEditDataKelengkapanFile extends NavigatorAction {
  NavigateToHalamanEditDataKelengkapanFile(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO REPLACE HALAMAN DATA PENGALAMAN KERJA
class NavigateToReplaceHalamanDataPengalamanKerja extends NavigatorAction {
  NavigateToReplaceHalamanDataPengalamanKerja(
      BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DATA PENGALAMAN KERJA
class NavigateToHalamanDataPengalamanKerja extends NavigatorAction {
  NavigateToHalamanDataPengalamanKerja(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN TAMBAH DATA PENGALAMAN KERJA
class NavigateToHalamanAddDataPengalamanKerja extends NavigatorAction {
  NavigateToHalamanAddDataPengalamanKerja(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN EDIT PENGAJUAN DATA PENGALAMAN KERJA
class NavigateToHalamanEditPengajuanDataPengalamanKerja
    extends NavigatorAction {
  NavigateToHalamanEditPengajuanDataPengalamanKerja(
      BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN EDIT DATA PENGALAMAN KERJA
class NavigateToHalamanEditDataPengalamanKerja extends NavigatorAction {
  NavigateToHalamanEditDataPengalamanKerja(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN NOTIFIKASI AKUN
class NavigateToHalamanNotifikasiAkun extends NavigatorAction {
  NavigateToHalamanNotifikasiAkun(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO REPLACEMENT HALAMAN NOTIFIKASI AKUN
class NavigateToReplacementHalamanNotifikasiAkun extends NavigatorAction {
  NavigateToReplacementHalamanNotifikasiAkun(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN DETAIL NOTIFIKASI DATA DIRI
class NavigateToHalamanDetailDataDiri extends NavigatorAction {
  NavigateToHalamanDetailDataDiri(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DETAIL NOTIFIKASI DATA KELUARGA
class NavigateToHalamanDetailDataKeluarga extends NavigatorAction {
  NavigateToHalamanDetailDataKeluarga(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DETAIL NOTIFIKASI DATA PENDIDIKAN
class NavigateToHalamanDetailDataPendidikan extends NavigatorAction {
  NavigateToHalamanDetailDataPendidikan(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DETAIL NOTIFIKASI DATA PENGALAMAN KERJA
class NavigateToHalamanDetailDataPengalamanKerja extends NavigatorAction {
  NavigateToHalamanDetailDataPengalamanKerja(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DETAIL NOTIFIKASI DATA KELENGKAPAN FILE
class NavigateToHalamanDetailDataKelengkapanFile extends NavigatorAction {
  NavigateToHalamanDetailDataKelengkapanFile(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanListMonitorAbsen extends NavigatorAction {
  NavigateToHalamanListMonitorAbsen(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanListMonitorIzin extends NavigatorAction {
  NavigateToHalamanListMonitorIzin(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanListMonitorLembur extends NavigatorAction {
  NavigateToHalamanListMonitorLembur(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanListMonitor extends NavigatorAction {
  NavigateToHalamanListMonitor(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanListKontakPegawai extends NavigatorAction {
  NavigateToHalamanListKontakPegawai(BuildContext _context) {
    context = _context;
  }
}

class NavigateToDetailKontakPegawai extends NavigatorAction {
  NavigateToDetailKontakPegawai(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN SALES ACTIVITY
class NavigateToSalesActivityPage extends NavigatorAction {
  NavigateToSalesActivityPage(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN KAMBAN BOARD SALES ACTIVITY
class NavigateToKambanBoardSalesActivityPage extends NavigatorAction {
  NavigateToKambanBoardSalesActivityPage(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN ADD LAYANAN
class NavigateToAddLayanan extends NavigatorAction {
  NavigateToAddLayanan(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DETAIL SALES ACTIVITY
class NavigateToDetailSalesActivityPage extends NavigatorAction {
  NavigateToDetailSalesActivityPage(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO REPLACE HALAMAN DETAIL SALES ACTIVITY
class NavigateToReplaceDetailSalesActivityPage extends NavigatorAction {
  NavigateToReplaceDetailSalesActivityPage(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN TAMBAH AKTIVITAS SALES
class NavigateToAddAktivitasSalesPage extends NavigatorAction {
  NavigateToAddAktivitasSalesPage(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//NAVIGATE TO HALAMAN DAILY ACTIVITY
class NavigateToDailySalesActivityPage extends NavigatorAction {
  NavigateToDailySalesActivityPage(BuildContext _context) {
    context = _context;
  }
}

//NAVIGATE TO HALAMAN DETAIL DAILY ACTIVITY
class NavigateToDetailDailySalesActivityPage extends NavigatorAction {
  NavigateToDetailDailySalesActivityPage(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanCuti extends NavigatorAction {
  NavigateToHalamanCuti(BuildContext _context) {
    context = _context;
  }
}

class NavigateToHalamanListHistoryCuti extends NavigatorAction {
  NavigateToHalamanListHistoryCuti(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//KPI//
class NavigateToHalamanKpi extends NavigatorAction {
  NavigateToHalamanKpi(BuildContext _context) {
    context = _context;
  }
}

class NavigateToParentTabKpiSaya extends NavigatorAction {
  NavigateToParentTabKpiSaya(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToParentTabKpiTeam extends NavigatorAction {
  NavigateToParentTabKpiTeam(BuildContext _context) {
    context = _context;
  }
}

class NavigateToParentTabKpiApprovalTeam extends NavigatorAction {
  NavigateToParentTabKpiApprovalTeam(BuildContext _context) {
    context = _context;
  }
}

class NavigateToHalamanPengajuanKpiTeam extends NavigatorAction {
  NavigateToHalamanPengajuanKpiTeam(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanPengajuanKpiSaya extends NavigatorAction {
  NavigateToHalamanPengajuanKpiSaya(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanDetailPengajuanKpiSaya extends NavigatorAction {
  NavigateToHalamanDetailPengajuanKpiSaya(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanPengajuanKpiApprovalTeam extends NavigatorAction {
  NavigateToHalamanPengajuanKpiApprovalTeam(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanDetailApprovedKpi extends NavigatorAction {
  NavigateToHalamanDetailApprovedKpi(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanDetailApprovalKpiSaya extends NavigatorAction {
  NavigateToHalamanDetailApprovalKpiSaya(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

class NavigateToHalamanDetailDiterimaKpiSaya extends NavigatorAction {
  NavigateToHalamanDetailDiterimaKpiSaya(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}
//END KPI//

//CHECKPOINT//
class NavigateToPatroli extends NavigatorAction {
  NavigateToPatroli(BuildContext _context) {
    context = _context;
  }
}

class NavigateToDetailPatroli extends NavigatorAction {
  NavigateToDetailPatroli(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}

//END CHECK POINT//
//SOS//
class NavigateToHalamanPengajuanSos extends NavigatorAction {
  NavigateToHalamanPengajuanSos(BuildContext _context) {
    context = _context;
  }
}

class NavigateToHalamanListSos extends NavigatorAction {
  NavigateToHalamanListSos(BuildContext _context) {
    context = _context;
  }
}

class NavigateToDetailSos extends NavigatorAction {
  NavigateToDetailSos(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}
//END SOS//
//PKWT//
class NavigateToPkwtSaya extends NavigatorAction {
  NavigateToPkwtSaya(BuildContext _context) {
    context = _context;
  }
}

class NavigateToDetailPkwtSaya extends NavigatorAction {
  NavigateToDetailPkwtSaya(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}
class NavigateToPkwtReplace extends NavigatorAction {
  NavigateToPkwtReplace(BuildContext _context) {
    context = _context;
  }
}

class NavigateToDetailPkwtReplace extends NavigatorAction {
  NavigateToDetailPkwtReplace(BuildContext _context, var _data) {
    context = _context;
    data = _data;
  }
}
//END PKWT//

class NavigatorBloc extends Bloc<NavigatorAction, dynamic> {
  NavigatorBloc(this.navigatorKey) : super(null);
  final GlobalKey<NavigatorState> navigatorKey;

  @override
  Stream<dynamic> mapEventToState(NavigatorAction event) async* {
    if (event is NavigatePop)
      Navigator.pop(event.context!);
    else if (event is NavigateRemoveToDashboard)
      Navigator.pushReplacementNamed(event.context!, '/');
    else if (event is NavigateToAbsensiReplace)
      Navigator.pushReplacementNamed(event.context!, '/absensi_replace');
    else if (event is NavigateRemoveToLogin)
      Navigator.pushReplacementNamed(event.context!, '/login');
    else if (event is NavigateRemoveToSplashScreen)
      Navigator.pushReplacementNamed(event.context!, 'splash_screen');
    else if (event is NavigateRemoveToLoginSSO)
      Navigator.pushReplacementNamed(event.context!, '/login_sso');
    else if (event is NavigateToAbsensi)
      Navigator.pushNamed(event.context!, '/absensi');
    else if (event is NavigateToPengajuanIzin)
      Navigator.pushNamed(event.context!, '/pengajuan_izin');
    else if (event is NavigateToListIzin)
      Navigator.pushNamed(event.context!, '/list_izin');
    else if (event is NavigateToListRekapIzin)
      Navigator.pushNamed(event.context!, '/list_rekap_izin').then((value) =>
          BlocProvider.of<MonthPickerBloc>(event.context!)
              .add(SetDate(DateTime.now())));
    else if (event is NavigateToDetailIzin)
      navigatorKey.currentState!
          .pushNamed('/detail_izin', arguments: event.data)
          .then((value) => {
                if (event.data[2] == 'notif')
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Izin')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToNotif)
      Navigator.pushNamed(event.context!, '/list_notif').then((value) =>
          BlocProvider.of<BadgeNotificationDashboardBloc>(event.context!)
              .add(GetBadgeNotificationDashboard(event.context!)));
    else if (event is NavigateToDetailImageClicked)
      Navigator.pushNamed(event.context!, '/detail_image_clicked',
          arguments: event.data);
    else if (event is NavigateToDetailImageClickedAkun)
      Navigator.pushNamed(event.context!, '/detail_image_clicked_akun',
          arguments: event.data);
    else if (event is NavigateToCamera)
      Navigator.pushNamed(event.context!, '/camera_app', arguments: event.data);
    else if (event is NavigateToListRekapAbsensi)
      Navigator.pushNamed(event.context!, '/list_absensi');
    // .then((value) =>
    //     BlocProvider.of<MonthPickerBloc>(event.context!)
    //         .add(SetDate(DateTime.now())));
    else if (event is NavigateToTukarShiftReplace)
      Navigator.pushReplacementNamed(event.context!, '/tukar_shift_replace',
          arguments: event.data);
    else if (event is NavigateToDetailListRekapAbsensi)
      Navigator.pushNamed(event.context!, '/detail_absensi',
          arguments: event.data);
    else if (event is NavigateToPengajuanLembur)
      Navigator.pushNamed(event.context!, '/pengajuan_lembur').then((value) =>
          BlocProvider.of<LemburBloc>(event.context!)
              .add(getListLemburEvent(event.context, null)));
    else if (event is NavigateToListLembur)
      Navigator.pushNamed(event.context!, '/list_lembur');
    else if (event is NavigateToListRekapLembur)
      Navigator.pushNamed(event.context!, '/list_rekap_lembur').then((value) =>
          BlocProvider.of<MonthPickerBloc>(event.context!)
              .add(SetDate(DateTime.now())));
    else if (event is NavigateToDetailLembur)
      Navigator.pushNamed(event.context!, '/detail_lembur',
              arguments: event.data)
          .then((value) => {
                if (event.data[2] == 'notif')
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Lembur')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToPengajuanAktivitas)
      Navigator.pushNamed(event.context!, '/pengajuan_aktivitas');
    else if (event is NavigateToListAktivitas)
      Navigator.pushNamed(event.context!, '/list_aktivitas');
    else if (event is NavigateToHalamanAkun)
      Navigator.pushNamed(event.context!, '/akun');
    else if (event is NavigateToRepaceHalamanAkun)
      Navigator.pushReplacementNamed(event.context!, '/akun');
    else if (event is NavigateToUbahPassword)
      Navigator.pushNamed(event.context!, '/ubah_password');
    else if (event is NavigateToDetailAktivitas)
      Navigator.pushNamed(event.context!, '/detail_aktivitas',
          arguments: event.data);
    else if (event is NavigateToDetailBerita)
      Navigator.pushNamed(event.context!, '/detail_berita',
              arguments: event.data)
          .then((value) => {
                print(event.data),
                if (event.data.length > 0)
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Berita')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToDetailPengumuman)
      Navigator.pushNamed(event.context!, '/detail_pengumuman',
              arguments: event.data)
          .then((value) => {
                if (event.data.length > 0)
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Pengumuman')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToListBerita)
      Navigator.pushNamed(event.context!, '/list_berita');
    else if (event is NavigateToShift)
      Navigator.pushNamed(event.context!, '/parent_shift');
    else if (event is NavigateToTukarShift)
      Navigator.pushNamed(event.context!, '/parent_tukar_shift',
          arguments: 'shift_saya');
    else if (event is NavigateToDetailTukarShift)
      Navigator.pushNamed(event.context!, '/detail_tukar_shift',
              arguments: event.data)
          .then((value) => {
                if (event.data[2] == 'notif')
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Shift')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToGaji)
      Navigator.pushNamed(event.context!, '/info_gaji');
    else if (event is NavigateToSlipGaji)
      Navigator.pushNamed(event.context!, '/slip_gaji', arguments: event.data);
    else if (event is NavigateToMainReimbursement)
      Navigator.pushNamed(event.context!, '/main_reimbursement');
    else if (event is NavigateRemoveToMainReimbursement)
      Navigator.pushReplacementNamed(event.context!, '/main_reimbursement');
    else if (event is NavigateToMainRekapReimbursement)
      Navigator.pushNamed(event.context!, '/main_rekap_reimbursement');
    else if (event is NavigateToDetailReimbursement) {
      Navigator.pushNamed(event.context!, '/detail_reimbursement',
              arguments: event.data)
          .then((value) {
        if (event.data[1] == 'reimbursementKaryawan') //konteks karyawan
          BlocProvider.of<reimbursementKaryawanBloc.ReimbursementKaryawanBloc>(
                  event.context!)
              .add(reimbursementKaryawanBloc.GetListReimbursementEvent(
                  event.context, null));
        else if (event.data[1] == 'reimbursementSaya') //konteks saya
          BlocProvider.of<ReimbursementSayaBloc>(event.context!)
              .add(GetListReimbursementEvent(event.context, null));
      });
    } else if (event is NavigateToPengajuanReimbursement)
      Navigator.pushNamed(event.context!, '/pengajuan_reimbursement');
    else if (event is NavigateToTambahItemPengajuanReimbursement)
      await Navigator.pushNamed(
              event.context!, '/tambah_item_pengajuan_reimbursement',
              arguments: event.data)
          .then((value) {
        if (event.data != null) {
          if (value != null) {
            // print('ada callback');
            BlocProvider.of<ReimbursementDetailBloc>(event.context!)
                .add(RevisiReimbursementItemEvent(value as DataItem));
            BlocProvider.of<CardItemReimbursementBloc>(event.context!)
                .add(GantiStatusEvent(event.context, "Sudah Direvisi"));
          } else {
            // print('tidak ada callback');
          }
        } else {
          // print('event data kosong');
          BlocProvider.of<ReimbursementItemBloc>(event.context!)
              .add(GetListReimbursementItemEvent(event.context));
        }
      });
    else if (event is NavigateToEditItemPengajuanReimbursement)
      await Navigator.pushNamed(
              event.context!, '/edit_item_pengajuan_reimbursement',
              arguments: event.data)
          .then((value) {
        if (event.data != null) {
          if (value != null) {
            // print('ada callback');
            BlocProvider.of<ReimbursementDetailBloc>(event.context!)
                .add(RevisiReimbursementItemEvent(value as DataItem));
          } else {
            // print('tidak ada callback');
            BlocProvider.of<ReimbursementItemBloc>(event.context!)
                .add(GetListReimbursementItemEvent(event.context!));
          }
        } else {
          // print('event data kosong');
          BlocProvider.of<ReimbursementItemBloc>(event.context!)
              .add(GetListReimbursementItemEvent(event.context));
        }
      });
    // else if (event is NavigateToDetailShiftTeman)
    //   Navigator.pushNamed(event.context!, '/detail_shift_teman',
    //       arguments: event.data);
    // else if (event is NavigateToDetailShiftKaryawan)
    //   Navigator.pushNamed(event.context!, '/detail_shift_karyawan',
    //       arguments: event.data);
    // else if (event is NavigateToPengajuanTukarShift)
    //   Navigator.pushNamed(event.context!, '/pengajuan_tukar_shift',
    //       arguments: event.data);
    else if (event is NavigateToFaceRecognition)
      Navigator.pushNamed(event.context!, '/face_recognition',
          arguments: event.data);
    else if (event is NavigateToFaceRegistration)
      Navigator.pushNamed(event.context!, '/face_registration',
          arguments: event.data);
    else if (event is NavigateToRekapKaryawan)
      Navigator.pushNamed(event.context!, '/rekap_karyawan');
    else if (event is NavigateToDetailMap)
      Navigator.pushNamed(event.context!, '/detail_map', arguments: event.data);
    else if (event is NavigateToHalamanDataDiri)
      Navigator.pushNamed(event.context!, '/datadiri', arguments: event.data);
    else if (event is NavigateToHalamanEditDataDiri)
      Navigator.pushNamed(event.context!, '/editdatadiri');
    else if (event is NavigateToHalamanEditDataPengajuanDataDiri)
      Navigator.pushNamed(event.context!, '/edit_pengajuan_data_diri');
    else if (event is NavigateToHalamanDataKeluarga)
      Navigator.pushNamed(event.context!, '/data_keluarga',
          arguments: event.data);
    else if (event is NavigateToReplaceHalamanDataKeluarga)
      Navigator.pushReplacementNamed(event.context!, '/data_keluarga',
          arguments: event.data);
    else if (event is NavigateToHalamanAddDataKeluarga)
      Navigator.pushNamed(event.context!, '/adddatakeluarga');
    else if (event is NavigateToHalamanEditPengajuanDataKeluarga)
      Navigator.pushNamed(event.context!, '/editpengajuandatakeluarga',
          arguments: event.data);
    else if (event is NavigateToHalamanEditDataKeluarga)
      Navigator.pushNamed(event.context!, '/editdatakeluarga',
          arguments: event.data);
    else if (event is NavigateToHalamanDataPendidikan)
      Navigator.pushNamed(event.context!, '/data_pendidikan',
          arguments: event.data);
    else if (event is NavigateToReplaceHalamanDataPendidikan)
      Navigator.pushReplacementNamed(event.context!, '/data_pendidikan',
          arguments: event.data);
    else if (event is NavigateToHalamanAddDataPendidikan)
      Navigator.pushNamed(event.context!, '/add_data_pendidikan');
    else if (event is NavigateToHalamanEditPengajuanDataPendidikan)
      Navigator.pushNamed(event.context!, '/edit_pengajuan_data_pendidikan',
          arguments: event.data);
    else if (event is NavigateToHalamanEditDataPendidikan)
      Navigator.pushNamed(event.context!, '/edit_data_pendidikan',
          arguments: event.data);
    else if (event is NavigateToHalamanDataKelengkapanFile)
      Navigator.pushNamed(event.context!, '/data_kelengkapan_file',
          arguments: event.data);
    else if (event is NavigateToReplaceHalamanDataKelengkapanFile)
      Navigator.pushReplacementNamed(event.context!, '/data_kelengkapan_file',
          arguments: event.data);
    else if (event is NavigateToHalamanAddDataKelengkapanFile)
      Navigator.pushNamed(event.context!, '/add_data_kelengkapan_file');
    else if (event is NavigateToHalamanEditPengajuanDataKelengkapanFile)
      Navigator.pushNamed(
          event.context!, '/edit_pengajuan_data_kelengkapan_file',
          arguments: event.data);
    else if (event is NavigateToHalamanEditDataKelengkapanFile)
      Navigator.pushNamed(event.context!, '/edit_data_kelengkapan_file',
          arguments: event.data);
    else if (event is NavigateToHalamanDataPengalamanKerja)
      Navigator.pushNamed(event.context!, '/data_pengalaman_kerja',
          arguments: event.data);
    else if (event is NavigateToReplaceHalamanDataPengalamanKerja)
      Navigator.pushReplacementNamed(event.context!, '/data_pengalaman_kerja',
          arguments: event.data);
    else if (event is NavigateToHalamanAddDataPengalamanKerja)
      Navigator.pushNamed(event.context!, '/add_data_pengalaman_kerja');
    else if (event is NavigateToHalamanEditPengajuanDataPengalamanKerja)
      Navigator.pushNamed(
          event.context!, '/edit_pengajuan_data_pengalaman_kerja',
          arguments: event.data);
    else if (event is NavigateToHalamanEditDataPengalamanKerja)
      Navigator.pushNamed(event.context!, '/edit_data_pengalaman_kerja',
          arguments: event.data);
    else if (event is NavigateToHalamanNotifikasiAkun)
      Navigator.pushNamed(event.context!, '/notifikasi_akun');
    else if (event is NavigateToReplacementHalamanNotifikasiAkun)
      Navigator.pushReplacementNamed(event.context!, '/notifikasi_akun');
    else if (event is NavigateToHalamanDetailDataDiri)
      Navigator.pushNamed(event.context!, '/detail_data_diri',
          arguments: event.data);
    else if (event is NavigateToHalamanDetailDataKeluarga)
      Navigator.pushNamed(event.context!, '/detail_data_keluarga',
          arguments: event.data);
    else if (event is NavigateToHalamanDetailDataPendidikan)
      Navigator.pushNamed(event.context!, '/detail_data_pendidikan',
          arguments: event.data);
    else if (event is NavigateToHalamanDetailDataPengalamanKerja)
      Navigator.pushNamed(event.context!, '/detail_data_pengalaman_kerja',
          arguments: event.data);
    else if (event is NavigateToHalamanDetailDataKelengkapanFile)
      Navigator.pushNamed(event.context!, '/detail_data_kelengkapan_file',
          arguments: event.data);
    else if (event is NavigateToHalamanListMonitorAbsen)
      Navigator.pushNamed(event.context!, '/list_monitor_absen',
          arguments: event.data);
    else if (event is NavigateToHalamanListMonitorIzin)
      Navigator.pushNamed(event.context!, '/list_monitor_izin',
          arguments: event.data);
    else if (event is NavigateToHalamanListMonitorLembur)
      Navigator.pushNamed(event.context!, '/list_monitor_lembur',
          arguments: event.data);
    else if (event is NavigateToHalamanListMonitor)
      Navigator.pushNamed(event.context!, '/list_monitor',
          arguments: event.data);
    else if (event is NavigateToHalamanListKontakPegawai)
      Navigator.pushNamed(event.context!, '/list_kontak_pegawai');
    else if (event is NavigateToDetailKontakPegawai)
      Navigator.pushNamed(event.context!, '/detail_kontak_pegawai',
          arguments: event.data);
    else if (event is NavigateToSalesActivityPage) {
      Navigator.pushNamed(event.context!, '/sales_activity_page');
    } else if (event is NavigateToKambanBoardSalesActivityPage) {
      Navigator.pushNamed(event.context!, '/kamban_board_sales_activity_page');
    } else if (event is NavigateToAddLayanan) {
      Navigator.pushNamed(event.context!, '/add_layanan_kamban',
          arguments: event.data);
    } else if (event is NavigateToDetailSalesActivityPage) {
      Navigator.pushNamed(event.context!, '/detail_sales_activity',
              arguments: event.data)
          .then((value) => {
                value = value.toString().replaceAll("[", ""),
                value = value.toString().replaceAll("]", ""),
                if (value.toString().split(", ")[0] == "refresh")
                  {
                    // BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.data[0].idTahapanM, ModelFilter(monthYear: DateTime(DateTime.now().year, DateTime.now().month)))),
                    // BlocProvider.of<KambanBloc>(event.context!).add(getListDataKambanEvent(event.context!, event.data[0].idTahapanM, ModelFilter(monthYear: DateTime(DateTime.now().year, DateTime.now().month)))),
                    BlocProvider.of<TotalKambanBloc>(event.context!).add(
                        getTotalKambanEvent(
                            event.context!,
                            value.toString().split(", ")[1],
                            ModelFilter(
                                monthYear: DateTime(DateTime.now().year,
                                    DateTime.now().month)))),
                    BlocProvider.of<KambanBloc>(event.context!).add(
                        getListDataKambanEvent(
                            event.context!,
                            value.toString().split(", ")[1],
                            ModelFilter(
                                monthYear: DateTime(DateTime.now().year,
                                    DateTime.now().month)))),
                  },
              });
    } else if (event is NavigateToReplaceDetailSalesActivityPage) {
      Navigator.pushReplacementNamed(event.context!, '/detail_sales_activity',
          arguments: event.data);
    } else if (event is NavigateToAddAktivitasSalesPage) {
      Navigator.pushNamed(event.context!, '/add_sales_activity',
          arguments: event.data);
    } else if (event is NavigateToDailySalesActivityPage) {
      Navigator.pushNamed(event.context!, '/daily_sales_activity',
          arguments: event.data);
    } else if (event is NavigateToDetailDailySalesActivityPage) {
      Navigator.pushNamed(event.context!, '/detail_daily_sales_activity',
          arguments: event.data);
    } else if (event is NavigateToHalamanCuti)
      Navigator.pushNamed(event.context!, '/cuti');
    else if (event is NavigateToHalamanListHistoryCuti) {
      Navigator.pushNamed(event.context!, '/list_history_cuti',
          arguments: event.data);
    }
    //KPI//
    else if (event is NavigateToHalamanKpi)
      Navigator.pushNamed(event.context!, '/kpi');
    else if (event is NavigateToParentTabKpiTeam)
      Navigator.pushNamed(event.context!, '/parent_tab_kpi_team');
    else if (event is NavigateToParentTabKpiApprovalTeam)
      Navigator.pushNamed(event.context!, '/parent_tab_kpi_approval_team');
    else if (event is NavigateToParentTabKpiSaya)
      Navigator.pushNamed(event.context!, '/parent_tab_kpi_saya',
          arguments: event.data);
    else if (event is NavigateToHalamanPengajuanKpiTeam)
      Navigator.pushNamed(event.context!, '/halaman_pengajuan_kpi_team',
          arguments: event.data);
    else if (event is NavigateToHalamanPengajuanKpiSaya)
      Navigator.pushNamed(event.context!, '/halaman_pengajuan_kpi_saya',
              arguments: event.data)
          .then((value) => {
                BlocProvider.of<NotifBloc>(event.context!)
                    .add(BacaNotifNotifKpi(
                  event.data[0],
                  event.data[1],
                  event.data[2],
                  event.data[3],
                  '6',
                )),
                if (event.data.length > 5 && event.data[5] == 'notif')
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Kpi')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToHalamanPengajuanKpiApprovalTeam)
      Navigator.pushNamed(
              event.context!, '/halaman_pengajuan_kpi_approval_team',
              arguments: event.data)
          .then((value) => {
                BlocProvider.of<NotifBloc>(event.context!)
                    .add(BacaNotifNotifKpi(
                  event.data[0],
                  event.data[1],
                  event.data[2],
                  event.data[3],
                  '1',
                )),
                if (event.data.length > 5 && event.data[5] == 'notif')
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Kpi')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToHalamanDetailApprovedKpi)
      Navigator.pushNamed(event.context!, '/halaman_detail_approval_kpi',
              arguments: event.data)
          .then((value) => {
                BlocProvider.of<NotifBloc>(event.context!)
                    .add(BacaNotifNotifKpi(
                  event.data[0],
                  event.data[1],
                  event.data[2],
                  event.data[3],
                  '9',
                )),
                if (event.data.length > 5 && event.data[5] == 'notif')
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Kpi')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToHalamanDetailApprovalKpiSaya)
      Navigator.pushNamed(event.context!, '/halaman_detail_approval_kpi_saya',
              arguments: event.data)
          .then((value) => {
                BlocProvider.of<NotifBloc>(event.context!)
                    .add(BacaNotifNotifKpi(
                  event.data[0],
                  event.data[1],
                  event.data[2],
                  event.data[3],
                  '4',
                )),
                if (event.data.length > 5 && event.data[5] == 'notif')
                  {
                    BlocProvider.of<NotifBloc>(event.context!)
                        .add(NotifDataEvent(event.context!, 'Kpi')),
                    BlocProvider.of<BadgeNotifBloc>(event.context!)
                        .add(GetBadgepercolumn(event.context!))
                  }
              });
    else if (event is NavigateToHalamanDetailDiterimaKpiSaya)
      Navigator.pushNamed(event.context!, '/halaman_detail_diterima_kpi_saya',
          arguments: event.data);
    else if (event is NavigateToHalamanDetailPengajuanKpiSaya)
      Navigator.pushNamed(event.context!, '/halaman_detail_pengajuan_kpi_saya',
          arguments: event.data);
    //END KPI//
    //START CHEKPOINT//
    else if (event is NavigateToPatroli)
      Navigator.pushNamed(event.context!, '/patroli');
    else if (event is NavigateToDetailPatroli)
      Navigator.pushNamed(event.context!, '/detail_patroli',
          arguments: event.data);
    //END CHECKPOINT//
    //SOS//
    else if (event is NavigateToHalamanPengajuanSos)
      Navigator.pushNamed(event.context!, '/pengajuan_sos');
    else if (event is NavigateToHalamanListSos)
      Navigator.pushNamed(event.context!, '/halaman_list_sos');
    else if (event is NavigateToDetailSos)
      Navigator.pushNamed(event.context!, '/halaman_detail_sos',
          arguments: event.data);
    //END SOS//
    //PKWT//
    else if (event is NavigateToPkwtSaya)
      Navigator.pushNamed(event.context!, '/list_pkwt_saya');
    else if (event is NavigateToDetailPkwtSaya)
      navigatorKey.currentState!
          .pushNamed('/detail_pkwt_saya', arguments: event.data);
    else if (event is NavigateToPkwtReplace)
      Navigator.pushReplacementNamed(event.context!, '/list_pkwt_saya_replace');
    else if (event is NavigateToDetailPkwtReplace)
      Navigator.pushReplacementNamed(
          event.context!, '/detail_pkwt_saya_replace',
          arguments: event.data);
    //END PKWT//
  }
}
