import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/lemburApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';
import '../CustomFunction.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

import '../NavigatorBloc.dart';
import 'DetailLemburBloc.dart';

abstract class LemburPegawaiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListLemburPegawaiEvent extends LemburPegawaiEvent{
  ModelFilter? modelFilter;
  getListLemburPegawaiEvent(BuildContext? _context, this.modelFilter){
    context = _context;
  }
}

class setujuiLembur extends LemburPegawaiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idLemmulai;
  String pageActionFrom;
  String? mulai;
  String? selesai;
  setujuiLembur(this.idLemmulai, this.context, this.scaffoldKey, this.pageActionFrom,{
    this.mulai,
    this.selesai
  });
}

class MewakiliSetujuiLembur extends LemburPegawaiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idLemmulai;
  String pageActionFrom;
  MewakiliSetujuiLembur(this.idLemmulai, this.context, this.scaffoldKey, this.pageActionFrom);
}

class tolakLembur extends LemburPegawaiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idLemmulai;
  String pageActionFrom;
  tolakLembur(this.idLemmulai, this.context, this.scaffoldKey, this.pageActionFrom);
}

class MewakiliTolakLembur extends LemburPegawaiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idLemmulai;
  String pageActionFrom;
  MewakiliTolakLembur(this.idLemmulai, this.context, this.scaffoldKey, this.pageActionFrom);
}

class loadMoreEvent extends LemburPegawaiEvent{
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController){
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class LemburPegawaiState{
  List<DataLembur>? data;
  DataLembur? dataDetail;
}

class getListLemburKaryawanSuccessState extends LemburPegawaiState{
  getListLemburKaryawanSuccessState(LemburPegawaiEvent _event, List<DataLembur>? _data){
    data = _data;
  }
}

class parseDataLemburPegawaiState extends LemburPegawaiState{
  parseDataLemburPegawaiState(DataLembur _dataDetail){
    dataDetail = _dataDetail;

  }
}

class LemburPegawaiProgressState extends LemburPegawaiState{}

class LoadMoreProgressState extends LemburPegawaiState{
  LoadMoreProgressState(List<DataLembur>? _data){
    data = _data;
  }
}

class LemburPegawaiErrorState extends LemburPegawaiState{}

class LemburPegawaiBloc extends Bloc<LemburPegawaiEvent, LemburPegawaiState>{
  final dateFormat = new DateFormat('yyyy-MM');
  LemburPegawaiState? initialState;
  List<DataLembur>? listLembur;
  int offset = 0;
  int limit = ServerInfo.limit;
  ModelFilter? modelFilter;

  LemburPegawaiBloc(LemburPegawaiState initialState) : super(initialState);

  @override
  Stream<LemburPegawaiState> mapEventToState(LemburPegawaiEvent event) async*{
    // TODO: implement mapEventToState
    if(event is getListLemburPegawaiEvent){
      offset = 0;
      modelFilter = event.modelFilter;
      yield LemburPegawaiProgressState();
      LemburRespon izinRespon = await LemburApi().getDataLembur(offset, 'lemburPegawai', modelFilter);
      if(izinRespon.success!){
        listLembur = izinRespon.data;
        yield getListLemburKaryawanSuccessState(event, listLembur);
      }
      else yield LemburPegawaiErrorState();
    }
    else if(event is loadMoreEvent){
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listLembur);
        LemburRespon izinRespon = await LemburApi().getDataLembur(offset, 'lemburPegawai', modelFilter);
        if(izinRespon.success!){
          listLembur!.addAll(izinRespon.data!);
        }
        yield getListLemburKaryawanSuccessState(event, listLembur);
      }
    }
    else if(event is setujuiLembur){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);

      BasicRespon basicRespon = await LemburApi().setujuiLembur(event.idLemmulai,mulai: event.mulai?.isNotEmpty == true ? event.mulai : null,
        selesai: event.selesai?.isNotEmpty == true ? event.selesai : null,);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message,event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if(event.pageActionFrom=='listLemburPegawai')
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
        else if(event.pageActionFrom=='detailLembur'){
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
          BlocProvider.of<DetailLemburBloc>(event.context!).add(GetDetailLembur(event.idLemmulai, 'lemburPegawai'));
        }else if (event.pageActionFrom == 'editDetail') {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(
              getListLemburPegawaiEvent(
                  event.context, modelFilter != null ? modelFilter : null));
          BlocProvider.of<DetailLemburBloc>(event.context!)
              .add(GetDetailLembur(event.idLemmulai, 'lemburPegawai'));
        }
      });
    }

    else if(event is MewakiliSetujuiLembur){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await LemburApi().MewakiliSetujuiLembur(event.idLemmulai);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message,event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if(event.pageActionFrom=='listLemburPegawai')
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
        else if(event.pageActionFrom=='detailLembur'){
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
          BlocProvider.of<DetailLemburBloc>(event.context!).add(GetDetailLembur(event.idLemmulai, 'lemburPegawai'));
        }
      });
    }
    else if(event is tolakLembur){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await LemburApi().tolakLembur(event.idLemmulai);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message,event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if(event.pageActionFrom=='listLemburPegawai')
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
        else if(event.pageActionFrom=='detailLembur'){
          BlocProvider.of<DetailLemburBloc>(event.context!).add(GetDetailLembur(event.idLemmulai, 'lemburPegawai'));
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
        }

      });
    }
    else if(event is MewakiliTolakLembur){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await LemburApi().MewakiliTolakLembur(event.idLemmulai);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message,event.context);
      Future.delayed(Duration(milliseconds: 600)).then((value) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        if(event.pageActionFrom=='listLemburPegawai')
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
        else if(event.pageActionFrom=='detailLembur'){
          BlocProvider.of<DetailLemburBloc>(event.context!).add(GetDetailLembur(event.idLemmulai, 'lemburPegawai'));
          BlocProvider.of<LemburPegawaiBloc>(event.context!).add(getListLemburPegawaiEvent(event.context, modelFilter!=null?modelFilter:null));
        }

      });
    }
  }
}