import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/lemburApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';
import '../CustomFunction.dart';

abstract class LemburEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListLemburEvent extends LemburEvent {
  ModelFilter? modelFilter;
  getListLemburEvent(BuildContext? _context, this.modelFilter) {
    context = _context;
  }
}

class loadMoreEvent extends LemburEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

class batalkanLembur extends LemburEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idLemmulai;
  batalkanLembur(this.idLemmulai, this.context, this.scaffoldKey);
}

abstract class LemburState {
  List<DataLembur>? data;
  DataLembur? dataLembur;
}

class getListLemburSuccessState extends LemburState {
  getListLemburSuccessState(LemburEvent _event, List<DataLembur>? _data) {
    data = _data;
  }
}

class LemburProgressState extends LemburState {}

class LoadMoreProgressState extends LemburState {
  LoadMoreProgressState(List<DataLembur>? _data) {
    data = _data;
  }
}

class LemburErrorState extends LemburState {}

class LemburBloc extends Bloc<LemburEvent, LemburState> {
  LemburState? initialState;
  List<DataLembur>? listLembur;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  LemburBloc(LemburState initialState) : super(initialState);

  @override
  Stream<LemburState> mapEventToState(LemburEvent event) async* {
    if (event is getListLemburEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield LemburProgressState();
      LemburRespon lemburRespon =
          await LemburApi().getDataLembur(offset, 'lemburSaya', modelFilter);
      if (lemburRespon.success!) {
        listLembur = lemburRespon.data;
        yield getListLemburSuccessState(event, listLembur);
      } else
        yield LemburErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listLembur);
        LemburRespon lemburRespon =
            await LemburApi().getDataLembur(offset, 'lemburSaya', modelFilter);
        if (lemburRespon.success!) {
          listLembur!.addAll(lemburRespon.data!);
        }
        yield getListLemburSuccessState(event, listLembur);
      }
    } else if (event is batalkanLembur) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await LemburApi().batalkanLembur(event.idLemmulai);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 600)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<LemburBloc>(event.context!)
              .add(getListLemburEvent(event.context, null));
        });
      }
    }
  }
}
