import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart' as mDataPengajuan;
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class PublishKpiTeamEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class PublishKpiTeam extends PublishKpiTeamEvent {
  mDataPengajuan.ParsingModelKaryawan data;
  BuildContext? context;
  PublishKpiTeam(this.data, this.context);
}

abstract class PublishKpiTeamState {}

class PublishKpiTeamProgress extends PublishKpiTeamState {}

class PublishKpiTeamSayaKpiError extends PublishKpiTeamState {}

class PublishKpiTeamBloc
    extends Bloc<PublishKpiTeamEvent, PublishKpiTeamState> {
  PublishKpiTeamBloc(PublishKpiTeamState initialState) : super(initialState);

  @override
  Stream<PublishKpiTeamState> mapEventToState(
      PublishKpiTeamEvent event) async* {
    if (event is PublishKpiTeam) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi().publishKpiTeam(event.data);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          final monthYear = new DateTime(event.data.tahun!,event.data.bulan!,DateTime.now().day);
          BlocProvider.of<GetListKpiBloc>(event.context!).add(GetDataListKpi(
                      ModelFilterKpi(monthYear: monthYear)));
        }
      }
    }
  }
}
