import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class GetDataPengajuanKpiSayaEvent {
  BuildContext? context;
}

class GetDataPegajuanKpiSaya extends GetDataPengajuanKpiSayaEvent {
  GetDataPegajuanKpiSaya(BuildContext _context, this.id_karyawan,
      this.id_company, this.bulan, this.tahun) {
    context = _context;
  }

  int? bulan;
  String? id_company;
  String? id_karyawan;
  int? tahun;
}

abstract class GetDataPengajuanKpiSayaState {
  List<DataPengajuan>? data;
}

class DataPengajuanKpiSayaProgressState extends GetDataPengajuanKpiSayaState {}

class GetDataPengajuanKpiSayaSuccessState extends GetDataPengajuanKpiSayaState {
  GetDataPengajuanKpiSayaSuccessState(List<DataPengajuan>? _data) {
    data = _data;
  }
}

class DataPengajuanKpiErrorState extends GetDataPengajuanKpiSayaState {}

class GetDataPengajuanKpiSayaBloc
    extends Bloc<GetDataPengajuanKpiSayaEvent, GetDataPengajuanKpiSayaState> {
  GetDataPengajuanKpiSayaBloc(GetDataPengajuanKpiSayaState initialState)
      : super(initialState);

  int? bulan;
  DataPengajuanKpiTeamRespon? dataRespon;
  String? id_company;
  String? id_karyawan;
  List<DataPengajuan>? listDataPengajuan;
  int? tahun;

  @override
  Stream<GetDataPengajuanKpiSayaState> mapEventToState(
      GetDataPengajuanKpiSayaEvent event) async* {
    if (event is GetDataPegajuanKpiSaya) {
      yield DataPengajuanKpiSayaProgressState();
      dataRespon = await KpiApi().getDataPengajuanKpiSaya(
          event.id_karyawan, event.id_company, event.bulan, event.tahun);
      if (dataRespon!.success!) {
        listDataPengajuan = dataRespon!.data;
        yield GetDataPengajuanKpiSayaSuccessState(listDataPengajuan);
      } else {
        yield DataPengajuanKpiErrorState();
      }
    }
  }
}
