import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiTeamBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart' as mpengajuan;
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class SetujuiApprovalKpiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class SetujuiApprovalKpi extends SetujuiApprovalKpiEvent {
  mpengajuan.ParsingModelKaryawan data;
  String role;
  String carrer;
  BuildContext? context;
  SetujuiApprovalKpi(this.data, this.role, this.carrer, this.context);
}

abstract class SetujuiApprovalKpiState {}

class SetujuiApprovalKpiProgress extends SetujuiApprovalKpiState {}

class SetujuiApprovalKpiSayaKpiError extends SetujuiApprovalKpiState {}

class SetujuiApprovalKpiBloc
    extends Bloc<SetujuiApprovalKpiEvent, SetujuiApprovalKpiState> {
  SetujuiApprovalKpiBloc(SetujuiApprovalKpiState initialState)
      : super(initialState);

  @override
  Stream<SetujuiApprovalKpiState> mapEventToState(
      SetujuiApprovalKpiEvent event) async* {
    if (event is SetujuiApprovalKpi) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi()
          .setujuiApprovalKpi(event.data, event.role, event.carrer);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<GetDataListKpiPengajuanTeamBloc>(event.context!)
              .add(GetDataListKpiPengajuanTeam(ModelFilterKpi(status: '1,8')));
        }
      }
    }
  }
}
