import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataAspekKedisiplinan.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class GetDataPengajuanAspekKedisiplinanEvent {
  BuildContext? context;
}

class GetDataPengajuanAspekKedisiplinan
    extends GetDataPengajuanAspekKedisiplinanEvent {
  ParsingModelKaryawan dataParsing;
  GetDataPengajuanAspekKedisiplinan(BuildContext _context, this.dataParsing) {
    context = _context;
  }
}

class GetDataAspekKedisiplinan extends GetDataPengajuanAspekKedisiplinanEvent {
  ParsingModelKaryawan dataParsing;
  GetDataAspekKedisiplinan(BuildContext _context, this.dataParsing) {
    context = _context;
  }
}

abstract class GetDataPengajuanAspekKedisiplinanState {
  DataAspekKedisiplinan? data;
}

class DataPengajuanAspekKedisiplinanProgressState
    extends GetDataPengajuanAspekKedisiplinanState {}

class GetDataPengajuanAspekKepribadianSuccessState
    extends GetDataPengajuanAspekKedisiplinanState {
  GetDataPengajuanAspekKepribadianSuccessState(DataAspekKedisiplinan? _data) {
    data = _data;
  }
}

class DataPengajuanKpiErrorState
    extends GetDataPengajuanAspekKedisiplinanState {}

class GetDataPengajuanAspekKedisiplinanBloc extends Bloc<
    GetDataPengajuanAspekKedisiplinanEvent,
    GetDataPengajuanAspekKedisiplinanState> {
  DataPengajuanAspekKedisiplinan? dataRespon;
  DataAspekKedisiplinan? DataPengajuan;

  GetDataPengajuanAspekKedisiplinanBloc(
      GetDataPengajuanAspekKedisiplinanState initialState)
      : super(initialState);

  @override
  Stream<GetDataPengajuanAspekKedisiplinanState> mapEventToState(
      GetDataPengajuanAspekKedisiplinanEvent event) async* {
    if (event is GetDataPengajuanAspekKedisiplinan) {
      yield DataPengajuanAspekKedisiplinanProgressState();
      dataRespon =
          await KpiApi().getDataPengajuanAspekKedisiplinan(event.dataParsing);
      if (dataRespon!.success!) {
        DataPengajuan = dataRespon!.data;
        yield GetDataPengajuanAspekKepribadianSuccessState(DataPengajuan);
      }else{
        yield DataPengajuanKpiErrorState();
      }
    } else if (event is GetDataAspekKedisiplinan) {
      yield DataPengajuanAspekKedisiplinanProgressState();
      dataRespon = await KpiApi().getDataAspekKedisiplinan(event.dataParsing);
      if (dataRespon!.success!) {
        DataPengajuan = dataRespon!.data;
        yield GetDataPengajuanAspekKepribadianSuccessState(DataPengajuan);
      }
    }
  }
}
