import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/izinApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';
import '../CustomFunction.dart';
import 'package:intl/intl.dart';

abstract class IzinEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListIzinEvent extends IzinEvent {
  ModelFilter? modelFilter;
  getListIzinEvent(BuildContext? _context, this.modelFilter) {
    context = _context;
  }
}

class loadMoreEvent extends IzinEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

class pengajuanIzin extends IzinEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GlobalKey<FormState> formKey;
  ModelIzin modelIzin;
  pengajuanIzin(this.modelIzin, this.context, this.scaffoldKey, this.formKey);
}

class batalkanIzin extends IzinEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idIzin;
  batalkanIzin(this.idIzin, this.context, this.scaffoldKey);
}

abstract class IzinState {
  List<DataIzin>? data;
  DataIzin? dataDetail;
}

class getListIzinSuccessState extends IzinState {
  getListIzinSuccessState(IzinEvent _event, List<DataIzin>? _data) {
    data = _data;
  }
}

class parseDataIzinState extends IzinState {
  parseDataIzinState(DataIzin _dataDetail) {
    dataDetail = _dataDetail;
  }
}

class IzinProgressState extends IzinState {}

class LoadMoreProgressState extends IzinState {
  LoadMoreProgressState(List<DataIzin>? _data) {
    data = _data;
  }
}

class IzinErrorState extends IzinState {}

class IzinBloc extends Bloc<IzinEvent, IzinState> {
  final dateFormat = new DateFormat('yyyy-MM');
  IzinState? initialState;
  List<DataIzin>? listIzin;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  IzinBloc(IzinState initialState) : super(initialState);

  @override
  Stream<IzinState> mapEventToState(IzinEvent event) async* {
    if (event is getListIzinEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield IzinProgressState();
      IzinRespon izinRespon =
          await IzinApi().getDataIzin(offset, 'izinSaya', modelFilter);
      if (izinRespon.success!) {
        listIzin = izinRespon.data;
        yield getListIzinSuccessState(event, listIzin);
      } else
        yield IzinErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listIzin);
        IzinRespon izinRespon =
            await IzinApi().getDataIzin(offset, 'izinSaya', modelFilter);
        if (izinRespon.success!) {
          listIzin!.addAll(izinRespon.data!);
        }
        yield getListIzinSuccessState(event, listIzin);
      }
    } else if (event is pengajuanIzin) {
      if (event.formKey.currentState!.validate()) {
        ProgressDialog pd = ProgressDialog(context: event.context);
        ProgressDialogDelayed.show(pd);
        BasicRespon basicRespon =
            await IzinApi().pengajuanIzin(event.modelIzin);
        ProgressDialogDelayed.hide(pd);
        showSnackBarDelayed(
            event.scaffoldKey, basicRespon.message, event.context);
        if (basicRespon.success!) {
          BlocProvider.of<IzinBloc>(event.context!)
              .add(getListIzinEvent(event.context, null));
          Future.delayed(Duration(milliseconds: 2000)).then((value) {
            BlocProvider.of<NavigatorBloc>(event.context!)
                .add(NavigatePop(event.context));
          });
        }
      }
    } else if (event is batalkanIzin) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await IzinApi().batalkanIzin(event.idIzin);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        Future.delayed(Duration(milliseconds: 600)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<IzinBloc>(event.context!)
              .add(getListIzinEvent(event.context, null));
        });
      }
    }
  }
}
