import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownEvent {}

class GetDataDropdown extends DropdownEvent {
  ModelFilter? modelFilter;
  GetDataDropdown(this.modelFilter);
}

class SelectDataDropdown extends DropdownEvent {
  DataDropdown? selectedValue;
  SelectDataDropdown(this.selectedValue);
}

abstract class DropdownState {}

class DropdownProgressState extends DropdownState {}

class DropdownSuccessState extends DropdownState {
  DropdownRespon? dropdownRespon;
  DataDropdown? selectedValue;
  DropdownSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownErrorState extends DropdownState {}

class DropdownKaryawanBloc extends Bloc<DropdownEvent, DropdownState> {
  DataDropdown? selectedValue;
  DropdownRespon? dropdownRespon;

  DropdownKaryawanBloc(DropdownState initialState) : super(initialState);

  @override
  Stream<DropdownState> mapEventToState(DropdownEvent event) async* {
    if (event is GetDataDropdown) {
      yield DropdownProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownApi().getPegawaiV2(event.modelFilter);
      yield DropdownSuccessState(dropdownRespon, null);
    } else if (event is SelectDataDropdown) {
      selectedValue = event.selectedValue;
      yield DropdownSuccessState(dropdownRespon, selectedValue);
    }
  }
}
