import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownJenisPerusahaanEvent {}

class GetDataDropdownJenisPerusahaan extends DropdownJenisPerusahaanEvent {
  String jenisPerusahaan;
  GetDataDropdownJenisPerusahaan(this.jenisPerusahaan);
}

class SelectDataDropdownJenisPerusahaan extends DropdownJenisPerusahaanEvent {
  DataDropdown selectedValue;
  SelectDataDropdownJenisPerusahaan(this.selectedValue);
}

abstract class DropdownJenisPerusahaanState {}

class DropdownJenisPerusahaanProgressState extends DropdownJenisPerusahaanState {}

class DropdownJenisPerusahaanSuccessState extends DropdownJenisPerusahaanState {
  DropdownRespon dropdownRespon;
  DataDropdown? selectedValue;
  DropdownJenisPerusahaanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownJenisPerusahaanErrorState extends DropdownJenisPerusahaanState {}

class DropdownJenisPerusahaanBloc extends Bloc<DropdownJenisPerusahaanEvent, DropdownJenisPerusahaanState> {
  DropdownJenisPerusahaanBloc(DropdownJenisPerusahaanState initialState) : super(initialState);
  DataDropdown? selectedValue;
  DropdownRespon? dropdownRespon;

  @override
  Stream<DropdownJenisPerusahaanState> mapEventToState(DropdownJenisPerusahaanEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownJenisPerusahaan) {
      yield DropdownJenisPerusahaanProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownApi().getDataJenisPerusahaanMaster(event.jenisPerusahaan);
      if (dropdownRespon!.data != null)
        yield DropdownJenisPerusahaanSuccessState(dropdownRespon!, null);
      else
        yield DropdownJenisPerusahaanErrorState();
    } else if (event is SelectDataDropdownJenisPerusahaan) {
      selectedValue = event.selectedValue;
      yield DropdownJenisPerusahaanSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
