import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Service/izinApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownEvent {}

class GetDataDropdown extends DropdownEvent {}

class SelectDataDropdown extends DropdownEvent {
  DataJenisIzin? selectedValue;
  SelectDataDropdown(this.selectedValue);
}

abstract class DropdownState {}

class DropdownProgressState extends DropdownState {}

class DropdownSuccessState extends DropdownState {
  JenisIzinRespon? dropdownRespon;
  DataJenisIzin? selectedValue;
  DropdownSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownErrorState extends DropdownState {}

class DropdownJenisIzinBloc extends Bloc<DropdownEvent, DropdownState> {
  DataJenisIzin? selectedValue;
  JenisIzinRespon? dropdownRespon;

  DropdownJenisIzinBloc(DropdownState initialState) : super(initialState);

  @override
  Stream<DropdownState> mapEventToState(DropdownEvent event) async* {
    if (event is GetDataDropdown) {
      yield DropdownProgressState();
      selectedValue = null;
      dropdownRespon = await IzinApi().getJenisIzin();
      if (dropdownRespon!.data != null)
        yield DropdownSuccessState(dropdownRespon, null);
      else
        yield DropdownErrorState();
    } else if (event is SelectDataDropdown) {
      selectedValue = event.selectedValue;
      yield DropdownSuccessState(dropdownRespon, selectedValue);
    }
  }
}
