import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownStatusPerkawinanEvent {}

class GetDataDropdownStatusPerkawinan extends DropdownStatusPerkawinanEvent {}

class SelectDataDropdownStatusPerkawinan extends DropdownStatusPerkawinanEvent {
  JenisData selectedValue;
  SelectDataDropdownStatusPerkawinan(this.selectedValue);
}

abstract class DropdownStatusPerkawinanState {}

class DropdownStatusPerkawinanProgressState extends DropdownStatusPerkawinanState {}

class DropdownStatusPerkawinanSuccessState extends DropdownStatusPerkawinanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownStatusPerkawinanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownStatusPerkawinanErrorState extends DropdownStatusPerkawinanState {}

class DropdownStatusPerkawinanBloc extends Bloc<DropdownStatusPerkawinanEvent, DropdownStatusPerkawinanState> {
  DropdownStatusPerkawinanBloc(DropdownStatusPerkawinanState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownStatusPerkawinanState> mapEventToState(DropdownStatusPerkawinanEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownStatusPerkawinan) {
      yield DropdownStatusPerkawinanProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisStatusPerkawinan();
      if (dropdownRespon!.data != null)
        yield DropdownStatusPerkawinanSuccessState(dropdownRespon!, null);
      else
        yield DropdownStatusPerkawinanErrorState();
    } else if (event is SelectDataDropdownStatusPerkawinan) {
      selectedValue = event.selectedValue;
      yield DropdownStatusPerkawinanSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
