import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownProvinsiEvent {}

class GetDataDropdownProvinsi extends DropdownProvinsiEvent {}

class SelectSetValueDataDropdownProvinsi extends DropdownProvinsiEvent {
  JenisData selectedValue;
  SelectSetValueDataDropdownProvinsi(this.selectedValue);
}

class SelectDataDropdownProvinsi extends DropdownProvinsiEvent {
  JenisData selectedValue;
  SelectDataDropdownProvinsi(this.selectedValue);
}

abstract class DropdownProvinsiState {}

class DropdownProvinsiProgressState extends DropdownProvinsiState {}

class DropdownProvinsiSuccessState extends DropdownProvinsiState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownProvinsiSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownProvinsiSetValueSuccessState extends DropdownProvinsiState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownProvinsiSetValueSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownAgamaErrorState extends DropdownProvinsiState {}

class DropdownProvinsiBloc extends Bloc<DropdownProvinsiEvent, DropdownProvinsiState> {
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;
  DropdownProvinsiBloc(DropdownProvinsiState initialState) : super(initialState);

  @override
  Stream<DropdownProvinsiState> mapEventToState(DropdownProvinsiEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownProvinsi) {
      yield DropdownProvinsiProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisProvinsi();
      if (dropdownRespon!.data != null)
        yield DropdownProvinsiSuccessState(dropdownRespon!, null);
      else
        yield DropdownAgamaErrorState();
    } else if (event is SelectSetValueDataDropdownProvinsi) {
      selectedValue = event.selectedValue;
      yield DropdownProvinsiSetValueSuccessState(dropdownRespon!, selectedValue!);
    } else if (event is SelectDataDropdownProvinsi) {
      selectedValue = event.selectedValue;
      yield DropdownProvinsiSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
