import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownKelurahanEvent {}

class GetDataDropdownKelurahan extends DropdownKelurahanEvent {}

class SelectDataDropdownKelurahan extends DropdownKelurahanEvent {
  JenisData selectedValue;
  SelectDataDropdownKelurahan(this.selectedValue);
}

class ClearDataDropdownKelurahan extends DropdownKelurahanEvent {}

abstract class DropdownKelurahanState {}

class DropdownKelurahanProgressState extends DropdownKelurahanState {}

class DropdownKelurahanSuccessState extends DropdownKelurahanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownKelurahanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownKelurahanSetValueSuccessState extends DropdownKelurahanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownKelurahanSetValueSuccessState(this.dropdownRespon, this.selectedValue);
}

class SetKecamatan extends DropdownKelurahanEvent{
  String? idKecamatan;
  JenisData? selectedValue;
  SetKecamatan(this.idKecamatan, this.selectedValue);
}

class SetValueKecamatan extends DropdownKelurahanEvent{
  String? idKecamatan;
  JenisData? selectedValue;
  SetValueKecamatan(this.idKecamatan, this.selectedValue);
}

class DropdownKelurahanErrorState extends DropdownKelurahanState {}

class DropdownKelurahanBloc extends Bloc<DropdownKelurahanEvent, DropdownKelurahanState> {
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;
  DropdownKelurahanBloc(DropdownKelurahanState initialState) : super(initialState);

  @override
  Stream<DropdownKelurahanState> mapEventToState(DropdownKelurahanEvent event) async* {
    // TODO: implement mapEventToState
    // if (event is GetDataDropdownKelurahan) {
    //   yield DropdownKelurahanProgressState();
    //   selectedValue = null;
    //   dropdownRespon = await AkunApi().getJenisKelurahan();
    //   if (dropdownRespon.data != null)
    //     yield DropdownKelurahanSuccessState(dropdownRespon, null);
    //   else
    //     yield DropdownKelurahanErrorState();
    // } else
    if (event is SelectDataDropdownKelurahan) {
      selectedValue = event.selectedValue;
      yield DropdownKelurahanSuccessState(dropdownRespon!, selectedValue!);
    }else if(event is SetKecamatan){
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisKelurahan(event.idKecamatan);
      if (dropdownRespon!.data != null)
        yield DropdownKelurahanSuccessState(dropdownRespon!, event.selectedValue);
      else
        yield DropdownKelurahanErrorState();
    }else if(event is SetValueKecamatan){
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisKelurahan(event.idKecamatan);
      if (dropdownRespon!.data != null)
        yield DropdownKelurahanSetValueSuccessState(dropdownRespon!, event.selectedValue);
      else
        yield DropdownKelurahanErrorState();
    }else if(event is ClearDataDropdownKelurahan){
      selectedValue = null;
      dropdownRespon = null;
      yield DropdownKelurahanProgressState();
    }
  }
}
