import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownJenjangEvent {}

class GetDataDropdownJenjang extends DropdownJenjangEvent {}

class SelectDataDropdownJenjang extends DropdownJenjangEvent {
  JenisData selectedValue;
  SelectDataDropdownJenjang(this.selectedValue);
}

abstract class DropdownJenjangState {}

class DropdownJenjangProgressState extends DropdownJenjangState {}

class DropdownJenjangSuccessState extends DropdownJenjangState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownJenjangSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownJenjangErrorState extends DropdownJenjangState {}

class DropdownJenjangBloc extends Bloc<DropdownJenjangEvent, DropdownJenjangState> {
  DropdownJenjangBloc(DropdownJenjangState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownJenjangState> mapEventToState(DropdownJenjangEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownJenjang) {
      yield DropdownJenjangProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisJenjang();
      if (dropdownRespon!.data != null)
        yield DropdownJenjangSuccessState(dropdownRespon!, null);
      else
        yield DropdownJenjangErrorState();
    } else if (event is SelectDataDropdownJenjang) {
      selectedValue = event.selectedValue;
      yield DropdownJenjangSuccessState(dropdownRespon!, selectedValue);
    }
  }
}
