import 'package:absenkuv3/Repository/Model/PageModel/mButtonPage.dart';
import 'package:absenkuv3/Repository/Model/mFace.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

class ProgressDialogDelayed{
  ProgressDialogDelayed.show(ProgressDialog pd, {bool isDismissible=true}){
    pd.show(
      barrierDismissible: isDismissible,
        msg: 'Loading...',
        backgroundColor: Colors.white,
        progressType: ProgressType.normal,
        elevation: 10.0,
        max: 10
    );
  }
  ProgressDialogDelayed.hide(ProgressDialog pd){
    pd.close();
  }
  // ProgressDialogDelayed.show(context){
  //   ProgressDialog pd = new ProgressDialog(context: context);
  //   // pd.style(message: 'Mohon ditunggu...',
  //   //     borderRadius: 10.0,
  //   //     backgroundColor: Colors.white,
  //   //     progressWidget: CircularProgressIndicator(strokeWidth: 2,),
  //   //     elevation: 10.0,
  //   //     insetAnimCurve: Curves.easeInOut,
  //   //     progress: 0.0,
  //   //     padding: EdgeInsets.all(22),
  //   //     maxProgress: 100.0,
  //   //     progressTextStyle: TextStyle(
  //   //         color: Colors.black, fontSize: 13.0, fontWeight: FontWeight.w400),
  //   //     messageTextStyle: TextStyle(
  //   //         color: Colors.black, fontSize: 19.0, fontWeight: FontWeight.w600)
  //   // );
  //   pd.show(
  //     msg: 'Mohon ditunggu...',
  //       backgroundColor: Colors.white,
  //       progressType: ProgressType.normal,
  //       elevation: 10.0,
  //     max: 10
  //   );
  // }
  // ProgressDialogDelayed.hide(context){
  //   Future.delayed(Duration(milliseconds: 500)).then((value)=>ProgressDialog(context: context).close());
  // }
}

// class showSnackBarDelayed{
//   showSnackBarDelayed(key, message){
//     key.currentState.showSnackBar(SnackBar(backgroundColor : CustomStyle.color1,content: Text(message, style: TextStyle(color: Colors.white, fontWeight: FontWeight.bold),)));
//     // Future.delayed(Duration(milliseconds: 500)).then((value)=>key.currentState.showSnackBar(SnackBar(backgroundColor : CustomStyle.color1,content: Text(message, style: TextStyle(color: Colors.white, fontWeight: FontWeight.bold),))));
//   }
// }

class showSnackBarDelayed {
  showSnackBarDelayed(GlobalKey<ScaffoldState>? key,  message, BuildContext? context, {Color? backgroundColor, Color? textColor}) {
    ScaffoldMessenger.of(context!).showSnackBar(
        SnackBar(backgroundColor : backgroundColor==null?CustomStyle.color1:backgroundColor,content: Text(message, style: TextStyle(color: textColor==null?Colors.white:textColor, fontWeight: FontWeight.bold),)));
  }
}

class showSnackBarDelayedWithColors {
  showSnackBarDelayedWithColors(GlobalKey<ScaffoldState>? key,  message, BuildContext? context) {
    ScaffoldMessenger.of(context!).showSnackBar(
        SnackBar(backgroundColor : CustomStyle.colorRed,content: Text(message, style: TextStyle(color: Colors.white, fontWeight: FontWeight.bold),)));
  }
}



class CurrencyFormatter{
  static String IDR(value){
    final currencyFormatter = new NumberFormat("#,##0", "id_IDR");
    return 'Rp ${currencyFormatter.format(value)}';
  }
}

class DateLocaleID{
  final months = [
  'Januari',
  'Februari',
  'Maret',
  'April',
  'Mei',
  'Juni',
  'Juli',
  'Agustus',
  'September',
  'Oktober',
  'November',
  'Desember'
  ];
  String translateMonth(int month){
    return months[month-1];
  }
}

class CustomPopUp {
  String? message;
  bool doublePop;
  bool isDismissible;
  Widget? icon;
  Color? color;
  BuildContext? context;
  String? btnTutup;
  CustomPopUp.show(this.message, this.context, this.btnTutup, {this.doublePop = false, this.isDismissible = true, this.icon, this.color}){
    Future.delayed(Duration(milliseconds: 600)).then((value)=>
        showDialog(
          barrierDismissible: isDismissible,
            context: context!,
            builder: (BuildContext context) {
              return AlertDialog(
                shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.all(
                        Radius.circular(CustomStyle.boxRadius))
                ),
                content: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    icon??Icon(Icons.check_circle, color: Colors.green, size: 50,),
                    Container(
                        padding: EdgeInsets.symmetric(vertical: 12),
                        child: Text(message!, style: TextStyle(
                          color: color??Colors.green,
                          fontWeight: FontWeight.w600,
                          fontSize: CustomStyle.fontSizeSubTitle,
                        ), textAlign: TextAlign.center,)),
                    SizedBox(height: 6,),
                    Align(
                      alignment: Alignment.centerRight,
                      child: TemplateButton(
                        onClick: (){
                          BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigatePop(context));
                          if(doublePop) BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigatePop(context));
                        },
                        label: btnTutup,
                        color: Colors.transparent,
                        contentColor: CustomStyle.color1,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,),
                    )
                  ],
                ),
              );
            })
    );

  }


}

class CustomPopUpShiftLepas {
  String? message;
  bool doublePop;
  bool isDismissible;
  Widget? icon;
  Color? color;
  String? btnTutup;
  void Function()? closeCustom;
  BuildContext? context;
  CustomPopUpShiftLepas.show(this.message, this.context,this.btnTutup,
      {this.doublePop = false,
      this.isDismissible = true,
      this.icon,
      this.color,
      this.closeCustom}) {
    Future.delayed(Duration(milliseconds: 600)).then((value) => showDialog(
        barrierDismissible: isDismissible,
        context: context!,
        builder: (BuildContext context) {
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius:
                    BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                icon ??
                    Icon(
                      Icons.check_circle,
                      color: Colors.green,
                      size: 50,
                    ),
                Container(
                    padding: EdgeInsets.symmetric(vertical: 12),
                    child: Text(
                      message!,
                      style: TextStyle(
                        color: color ?? Colors.green,
                        fontWeight: FontWeight.w600,
                        fontSize: CustomStyle.fontSizeSubTitle,
                      ),
                      textAlign: TextAlign.center,
                    )),
                SizedBox(
                  height: 6,
                ),
                Align(
                  alignment: Alignment.centerRight,
                  child: TemplateButton(
                    onClick: () {
                      if (closeCustom != null) {
                        closeCustom!();
                      } else {
                        BlocProvider.of<NavigatorBloc>(context)
                            .add(NavigatePop(context));
                        if (doublePop)
                          BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigatePop(context));
                      }
                    },
                    label: btnTutup,
                    color: Colors.transparent,
                    contentColor: CustomStyle.color1,
                    fontSize: CustomStyle.fontSizeNormal,
                    bold: true,
                  ),
                )
              ],
            ),
          );
        }));
  }
}

class CustomPopUpRegistrasiWajah {
  BuildContext? context;
  String? title;
  String? btnLabel;
  List<DataFaceRegistrationInfo>? dataFaceRegistrationInfo;

  CustomPopUpRegistrasiWajah.show(this.dataFaceRegistrationInfo, this.context, this.title, this.btnLabel){
    Future.delayed(Duration(milliseconds: 600)).then((value) =>
        showDialog(
            barrierDismissible: true,
            context: context!,
            builder: (BuildContext context) {
              return AlertDialog(
                shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.all(
                        Radius.circular(CustomStyle.boxRadius))
                ),
                content: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        Icon(Icons.warning_amber_rounded, color: CustomStyle.color1, size: 46,),
                        SizedBox(width: 6,),
                        Text(title!, style: TextStyle(
                          color: CustomStyle.fontColorBlack,
                          fontWeight: FontWeight.w700,
                          fontSize: CustomStyle.fontSizeHeader,
                        )),
                      ],
                    ),
                    Container(
                        padding: EdgeInsets.only(top: 14, bottom: 12),
                        height: MediaQuery.of(context).size.height/2,
                        width: MediaQuery.of(context).size.width,
                        child: ListView.builder(
                            physics: AlwaysScrollableScrollPhysics(),
                            itemCount: dataFaceRegistrationInfo!.length,
                            itemBuilder: (BuildContext context, index) {
                              return TemplateRow(dataFaceRegistrationInfo![index].index, dataFaceRegistrationInfo![index].isi);
                            }
                        ),),
                    SizedBox(height: 6,),
                    Align(
                      alignment: Alignment.centerRight,
                      child: TemplateButton(
                        onClick: () {
                          BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigatePop(context));
                        },
                        label: btnLabel,
                        color: Colors.transparent,
                        contentColor: CustomStyle.color1,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,),
                    )
                  ],
                ),
              );
            })
    );
  }

  Widget TemplateRow(index, isi){
    return Container(
      margin: EdgeInsets.only(bottom: 4),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Expanded(
            flex: 1,
            child: Text('$index.', style: TextStyle(
              color: CustomStyle.fontColorBlack,
              fontSize: CustomStyle.fontSizeSubTitle,
            )),
          ),
          Expanded(
            flex: 6,
            child: Text('$isi.', style: TextStyle(
              color: CustomStyle.fontColorBlack,
              fontSize: CustomStyle.fontSizeSubTitle,
            )),
          ),
        ],
      ),
    );
  }
}


