import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mBadgepercolumn.dart';
import 'package:absenkuv3/Repository/Service/notifApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgeNotifEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class BadgeNotifState {}

class GetBadgeNotif extends BadgeNotifEvent {
  GetBadgeNotif(
    BuildContext _context,
  ) {
    context = _context;
  }
}

class GetBadgepercolumn extends BadgeNotifEvent {
  GetBadgepercolumn(
    BuildContext _context,
  ) {
    context = _context;
  }
}

class GetSuccess extends BadgeNotifState {
  JumlahBadge? dataDashboard;
  GetSuccess(this.dataDashboard) {}
}

class GetSuccessPerColumn extends BadgeNotifState {
  Badgepercolumn? dataColumn;
  GetSuccessPerColumn(this.dataColumn) {}
}

class GetProgress extends BadgeNotifState {}

class GetFailed extends BadgeNotifState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetFailed(this.message, this.scaffoldKey) {
    // showSnackBarDelayed(scaffoldKey, message);
  }
}

class BadgeNotifBloc extends Bloc<BadgeNotifEvent, BadgeNotifState> {
  BadgeNotifBloc(BadgeNotifState initialState) : super(initialState);

  @override
  Stream<BadgeNotifState> mapEventToState(BadgeNotifEvent event) async* {
    if (event is GetBadgeNotif) {
      yield GetProgress();
      JumlahBadge dashboardRespon = await NotifApi().badgeNotif();
      if (dashboardRespon.success!)
        yield GetSuccess(dashboardRespon);
      else
        yield GetFailed(dashboardRespon.message, event.scaffoldKey);
    } else if (event is GetBadgepercolumn) {
      yield GetProgress();
      Badgepercolumn dashboardRespon = await NotifApi().badgeNotifperColumn();
      if (dashboardRespon.success!)
        yield GetSuccessPerColumn(dashboardRespon);
      else
        yield GetFailed(dashboardRespon.message, event.scaffoldKey);
    }
  }
}
