// import 'package:absenkuv3/Bloc/CustomFunction.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter_bloc/flutter_bloc.dart';
// import 'package:absenkuv3/Repository/Model/mLogin.dart';
// import 'package:absenkuv3/Repository/Service/userApi.dart';
// import 'package:absenkuv3/Repository/sharedPreference.dart';
// import 'package:sn_progress_dialog/sn_progress_dialog.dart';
// import 'NavigatorBloc.dart';

// /// ==============================
// /// EVENT
// /// ==============================
// abstract class AuthSSOEvent {}

// class LoginWithTokenEvent extends AuthSSOEvent {
//   final String token;
//   final GlobalKey<ScaffoldState> scaffoldKey;

//   LoginWithTokenEvent(this.token, this.scaffoldKey);
// }

// class LogoutEvent extends AuthSSOEvent {
//   final GlobalKey<ScaffoldState> scaffoldKey;

//   LogoutEvent(this.scaffoldKey);
// }

// class LoadCachedUserEvent extends AuthSSOEvent {}

// /// ==============================
// /// STATE
// /// ==============================
// abstract class AuthState {}

// class AuthInitial extends AuthState {}

// class AuthLoading extends AuthState {}

// class AuthSuccess extends AuthState {
//   final LoginRespon data;

//   AuthSuccess(this.data);
// }

// class AuthLoggedOut extends AuthState {}

// class AuthFailure extends AuthState {
//   final String message;

//   AuthFailure(this.message);
// }

// /// ==============================
// /// BLOC
// /// ==============================
// class AuthBloc extends Bloc<AuthSSOEvent, AuthState> {
//   AuthBloc() : super(AuthInitial());

//   @override
//   Stream<AuthState> mapEventToState(AuthSSOEvent event) async* {
//     if (event is LoginWithTokenEvent) {
//       yield AuthLoading();
//       try {
//         ProgressDialog pd = ProgressDialog(context: event.context);
//         ProgressDialogDelayed.show(pd, isDismissible: false);
//         // Call login API with token
//         final response = await UserApi().loginSSOWithToken(event.token);

//       ProgressDialogDelayed.hide(pd);

//         if (response.success == true) {
//           await sharedPreferences().setUserData(response);
//           yield AuthSuccess(response);

//           // Navigate to dashboard
//           BlocProvider.of<NavigatorBloc>(event.scaffoldKey.currentContext!)
//               .add(NavigateRemoveToDashboard(event.scaffoldKey.currentContext));
//         } else {
//           showSnackBarDelayed(event.scaffoldKey, response.message);
//           yield AuthFailure(response.message ?? 'Login gagal');
//         }
//       } catch (e) {
//         ProgressDialogDelayed.hide(event.scaffoldKey.currentContext!);
//         showSnackBarDelayed(event.scaffoldKey, 'Terjadi kesalahan: $e');
//         yield AuthFailure(e.toString());
//       }
//     }

//     else if (event is LogoutEvent) {
//       yield AuthLoading();
//       try {
//         ProgressDialogDelayed.show(event.scaffoldKey.currentContext!);
//         await sharedPreferences().remove('user');
//         ProgressDialogDelayed.hide(event.scaffoldKey.currentContext!);
//         yield AuthLoggedOut();

//         BlocProvider.of<NavigatorBloc>(event.scaffoldKey.currentContext!)
//             .add(NavigateRemoveToLogin(event.scaffoldKey.currentContext));
//       } catch (e) {
//         ProgressDialogDelayed.hide(event.scaffoldKey.currentContext!);
//         showSnackBarDelayed(event.scaffoldKey, 'Logout gagal: $e');
//         yield AuthFailure(e.toString());
//       }
//     }

//     else if (event is LoadCachedUserEvent) {
//       final data = await sharedPreferences().getUserData();
//       if (data != null && data.success == true) {
//         yield AuthSuccess(data);
//       } else {
//         yield AuthLoggedOut();
//       }
//     }
//   }
// }
