import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Service/aktivitasApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailAktivitasEvent {}

class GetDetailAktivitas extends DetailAktivitasEvent {
  String? id;
  GetDetailAktivitas(this.id);
}

abstract class DetailAktivitasState {}

class DetailAktivitasProgress extends DetailAktivitasState {}

class DetailAktivitasSuccess extends DetailAktivitasState {
  AktivitasRespon aktivitasRespon;
  DetailAktivitasSuccess(this.aktivitasRespon);
}

class DetailAktivitasError extends DetailAktivitasState {}

class DetailAktivitasBloc
    extends Bloc<DetailAktivitasEvent, DetailAktivitasState> {
  DetailAktivitasBloc(DetailAktivitasState initialState) : super(initialState);

  @override
  Stream<DetailAktivitasState> mapEventToState(
      DetailAktivitasEvent event) async* {
    if (event is GetDetailAktivitas) {
      yield DetailAktivitasProgress();
      AktivitasRespon aktivitasRespon =
          await ActivitasApi().getDataDetailAktivitas(event.id);
      if (aktivitasRespon.success!)
        yield DetailAktivitasSuccess(aktivitasRespon);
      else
        yield DetailAktivitasError();
    }
  }
}
