import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Service/absensiApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class DataAbsensiPegawaiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListDataAbsensiPegawaiEvent extends DataAbsensiPegawaiEvent {
  ModelFilter? modelFilterDataAbsensi;
  getListDataAbsensiPegawaiEvent(
      BuildContext _context, this.modelFilterDataAbsensi) {
    context = _context;
  }
}
class getListDataAbsensiKaryawanEvent extends DataAbsensiPegawaiEvent {
  ModelFilter? modelFilterDataAbsensi;
  getListDataAbsensiKaryawanEvent(
      BuildContext _context, this.modelFilterDataAbsensi) {
    context = _context;
  }
}

class loadMoreEvent extends DataAbsensiPegawaiEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}
class loadMoreKaryawanEvent extends DataAbsensiPegawaiEvent {
  late ScrollController scrollController;
  loadMoreKaryawanEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class DataAbsensiPegawaiState {
  List<DataRekapAbsensi>? data;
  DataIzin? dataDetail;
}

class getListDataAbsensiPegawaiSuccessState extends DataAbsensiPegawaiState {
  getListDataAbsensiPegawaiSuccessState(
      DataAbsensiPegawaiEvent _event, List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class getListDataAbsensiKaryawanSuccessState extends DataAbsensiPegawaiState {
  getListDataAbsensiKaryawanSuccessState(
      DataAbsensiPegawaiEvent _event, List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class parseDataDataAbsensiPegawaiState extends DataAbsensiPegawaiState {
  parseDataDataAbsensiPegawaiState(DataIzin _dataDetail) {
    dataDetail = _dataDetail;
  }
}

class DataAbsensiPegawaiProgressState extends DataAbsensiPegawaiState {}

class LoadMoreProgressState extends DataAbsensiPegawaiState {
  LoadMoreProgressState(List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class DataAbsensiPegawaiErrorState extends DataAbsensiPegawaiState {}

class DataAbsensiPegawaiBloc
    extends Bloc<DataAbsensiPegawaiEvent, DataAbsensiPegawaiState> {
  DataAbsensiPegawaiState? initialState;
  List<DataRekapAbsensi>? listAbsensi;
  ModelFilter? modelFilterDataAbsensi;
  int offset = 0;
  int limit = ServerInfo.limit;

  DataAbsensiPegawaiBloc(DataAbsensiPegawaiState initialState)
      : super(initialState);

  @override
  Stream<DataAbsensiPegawaiState> mapEventToState(
      DataAbsensiPegawaiEvent event) async* {
    if (event is getListDataAbsensiPegawaiEvent) {
      offset = 0;
      yield DataAbsensiPegawaiProgressState();
      modelFilterDataAbsensi = event.modelFilterDataAbsensi;
      RekapAbsensiRespon absensiRespon = await AbsensiApi()
          .getDataAbsensiPegawai(modelFilterDataAbsensi, offset);
      if (absensiRespon.success!) {
        listAbsensi = absensiRespon.data;
        yield getListDataAbsensiPegawaiSuccessState(event, listAbsensi);
      } else
        yield DataAbsensiPegawaiErrorState();
    } else if (event is getListDataAbsensiKaryawanEvent) {
      offset = 0;
      yield DataAbsensiPegawaiProgressState();
      modelFilterDataAbsensi = event.modelFilterDataAbsensi;
      RekapAbsensiRespon absensiRespon = await AbsensiApi()
          .getDataAbsensiKaryawan(modelFilterDataAbsensi, offset);
      if (absensiRespon.success!) {
        listAbsensi = absensiRespon.data;
        yield getListDataAbsensiKaryawanSuccessState(event, listAbsensi);
      } else
        yield DataAbsensiPegawaiErrorState();
    }
    else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAbsensi);
        RekapAbsensiRespon absensiRespon = await AbsensiApi()
            .getDataAbsensiPegawai(modelFilterDataAbsensi, offset);
        if (absensiRespon.success!) {
          listAbsensi!.addAll(absensiRespon.data!);
        }
        yield getListDataAbsensiPegawaiSuccessState(event, listAbsensi);
      }
    }
    else if (event is loadMoreKaryawanEvent) {
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAbsensi);
        RekapAbsensiRespon absensiRespon = await AbsensiApi()
            .getDataAbsensiKaryawan(modelFilterDataAbsensi, offset);
        if (absensiRespon.success!) {
          listAbsensi!.addAll(absensiRespon.data!);
        }
        yield getListDataAbsensiKaryawanSuccessState(event, listAbsensi);
      }
    }
  }
}
