package com.example.absenkuv3.broadcast


import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import org.json.JSONObject


class BroadcastReceiverHandler : BroadcastReceiver() {

    private lateinit var callback: BroadcastReceiverHandlerListener

    fun setListener(callback: BroadcastReceiverHandlerListener) {
        this.callback = callback
    }

    override fun onReceive(context: Context?, intent: Intent?) {
        if (intent != null && intent.action == "action.REPORT_CAMERA") {
            val bundle = intent.getBundleExtra("reportCamera")

            if (bundle != null) {
                Log.d("INIBUNDLE", bundle.toString())
                val value1 = bundle.getString("foto")
                val value2 = bundle.getString("matrix")

                val valueMap = HashMap<String, String>()
                valueMap["foto"] = "'${value1}'" ?: ""
                valueMap["matrix"] = "'${value2.toString()}'" ?: ""

//                val stringBuilder = StringBuilder()
//                for ((key, value) in valueMap) {
//                    stringBuilder.append("$key: $value, ")
//                }
//
//                val valueString = stringBuilder.toString().removeSuffix(", ")


                val jsonObject = JSONObject()
                jsonObject.put("foto", value1)
                jsonObject.put("matrix", value2)

                val jsonString = jsonObject.toString()

                callback.onReportCamera(jsonString)

//                callback.onReportCamera(valueString)

            }
            else{
                Log.d("INIBUNDLE", bundle.toString())
            }
        }
    }

//    override fun onReceive(context: Context?, intent: Intent?) {
//        if (intent != null && intent.action == "action.REPORT_CAMERA") {
//
//            val info = intent.getStringExtra("reportCamera")
//            callback.onReportCamera(info)
//        }
//    }
}