import 'package:absenkuv3/Bloc/AppBlocProvider.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Setting/firebase_config.dart';
import 'package:absenkuv3/Setting/router.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_dotenv/flutter_dotenv.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:flutter_localizations/flutter_localizations.dart';

LoginRespon? loginRespon;

/// Global variables
/// * [GlobalKey<NavigatorState>]
class GlobalVariable {
  /// This global key is used in material app for navigation through firebase notifications.
  /// [navState] usage can be found in [notification_notifier.dart] file.
  static final GlobalKey<NavigatorState> navState = GlobalKey<NavigatorState>();
}


@pragma("vm:entry-point")

launcherUrl(String link) async {
  if (await canLaunch(link)) {
    await launch(link);
  } else {
    throw 'Could not launch $link';
  }
}

void main() async {
  await dotenv.load(fileName: ".env");
  WidgetsFlutterBinding.ensureInitialized();
  await SystemChrome.setPreferredOrientations(
      [DeviceOrientation.portraitDown, DeviceOrientation.portraitUp]);
  await Permission.notification.request();
  // initiateFCM();
  await Firebase.initializeApp();
  await initializeFirebase();
  loginRespon = await sharedPreferences().getUserData();
  runApp(MyApp());
}

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MultiBlocProvider(
      providers: AppBlocProviders.providers,
        child: MaterialApp(
          initialRoute: 'splash_screen',
          navigatorKey: GlobalVariable.navState,
          localizationsDelegates: [
            GlobalCupertinoLocalizations.delegate,
            GlobalMaterialLocalizations.delegate,
            // SfGlobalLocalizations.delegate
          ],
          //ignore: always_specify_types
          supportedLocales: const [
            Locale('id'),
            Locale('en'),
            // ... other locales the app supports
          ],
          locale: const Locale('id'),
          debugShowCheckedModeBanner: false,
          onGenerateRoute: RouterGenerator.generateRoute,

          title: 'Absenku Professional',
          theme: ThemeData(
            primarySwatch: Colors.blue,
            visualDensity: VisualDensity.adaptivePlatformDensity,
          ),
        ));
  }
}
