import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavbarBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mParentTabPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Rekap/halamanRekap.dart';
import 'package:absenkuv3/UI/Modul/Dashboard/halamanDashboard.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogConfirmation.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTab extends StatefulWidget {
  @override
  _ParentTabState createState() => _ParentTabState();
}

class _ParentTabState extends State<ParentTab> {
  final _listPage = <Widget>[
    HalamanDashboard(),
    Container(),
  ];

  @override
  void initState() {
    super.initState();
    FirebaseMessaging.instance.getInitialMessage().then((message) {
      if (message != null) {
        // Handle push notification routing here
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageParentTabModel>(
      future: PengaturanBahasa().parentTab(),
      builder: (context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done &&
            snapshot.hasData &&
            snapshot.data != null) {
          final tabData = snapshot.data!.parentTab;

          return BlocBuilder<AuthBloc, LoginRespon>(
            builder: (context, loginRespon) {
              if (loginRespon != false) {
                return BlocBuilder<NavbarBloc, int>(
                  builder: (context, currentIndex) {
                    return Scaffold(
                      body: WillPopScope(
                        onWillPop: () =>
                            _handleBackPress(currentIndex, tabData),
                        child: Stack(
                          children: [
                            IndexedStack(
                              index: currentIndex,
                              children: _listPage,
                            ),
                            Align(
                              alignment: Alignment.bottomCenter,
                              child: customBottomNavBar(
                                  context, currentIndex, tabData),
                            ),
                          ],
                        ),
                      ),
                    );
                  },
                );
              } else {
                return SizedBox.shrink();
              }
            },
          );
        } else {
          return Center(child: CircularProgressIndicator(strokeWidth: 6));
        }
      },
    );
  }

  /// Fungsi untuk konfirmasi keluar aplikasi
  Future<bool> _handleBackPress(int index, ParentTabData? tabData) async {
    if (index == 0) {
      await showDialog(
        context: context,
        barrierDismissible: false,
        builder: (context) => AlertConfirmation(
          message: tabData?.messageExit ?? 'Keluar dari aplikasi?',
          textBtnCancel: tabData?.textBtnCancel ?? 'Batal',
          textBtnSubmit: tabData?.textBtnSubmit ?? 'Keluar',
          onClick: () {
            SystemNavigator.pop();
          },
        ),
      );
    } else {
      context.read<NavbarBloc>().add(SetNavbar(0));
    }
    return false;
  }

  /// Custom Bottom Navigation Bar
  Widget customBottomNavBar(
      BuildContext context, int currentIndex, ParentTabData? tabData) {
    return Container(
      padding: EdgeInsets.symmetric(vertical: 10),
      decoration: BoxDecoration(
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: Colors.grey.withOpacity(0.2),
            blurRadius: 5,
            offset: Offset(0, 1),
          ),
        ],
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          _navItem(context, 0, currentIndex, tabData),
          _navItem(context, 1, currentIndex, tabData),
        ],
      ),
    );
  }

  /// Widget custom tab item (label + icon, ada dekorasi saat aktif)
  Widget _navItem(BuildContext context, int index, int currentIndex,
      ParentTabData? tabData) {
    final isActive = index == currentIndex;

    String title = '';
    String icon = '';
    String iconActive = '';

    if (index == 0) {
      title = 'Beranda';
      icon = ValueImage.iconBeranda;
      iconActive = ValueImage.iconBerandaAktif;
    } else {
      title = 'Data Presensi';
      icon = ValueImage.iconRekap;
      iconActive = ValueImage.iconRekapAktif;
    }

    return GestureDetector(
      onTap: () {
        context.read<NavbarBloc>().add(SetNavbar(index));
      },
      child: AnimatedContainer(
        duration: Duration(milliseconds: 250),
        padding: EdgeInsets.symmetric(horizontal: 16, vertical: 8),
        decoration: isActive
            ? BoxDecoration(
                color: Colors.purple.withOpacity(0.15),
                borderRadius: BorderRadius.circular(20),
              )
            : null,
        child: Row(
          children: [
            Image.asset(
              isActive ? iconActive : icon,
              width: 24,
              height: 24,
            ),
            SizedBox(width: 8),
            Text(
              title.toUpperCase(),
              style: TextStyle(
                color: isActive ? Colors.purple : Colors.grey,
                fontWeight: FontWeight.bold,
              ),
            ),
          ],
        ),
      ),
    );
  }
}
