import 'package:absenkuv3/UI/Template/style.dart';  
import 'package:flutter/material.dart';  

class TemplateTextFormV2 extends StatefulWidget {  
  final Key? fieldKey;  
  final String? hintText;  
  final String? labelText;  
  final String? helperText;  
  final String? titleText;  
  var color;  
  bool flagColorBackground;  
  var initialValue;  
  final double fontSize;  
  final FormFieldSetter<String>? onSaved;  
  final FormFieldSetter<String>? onChange;  
  final FormFieldValidator<String>? validator;  
  final TextEditingController? controller;  
  final TextCapitalization textCapitalization;  
  final bool enabled;  
  final bool adaValidasi;  
  final bool keyboardNumber;  
  final double bottomMargin;  
  final double radius;  
  final int maxLine; // Ideally this should allow more lines, adjust as needed  
  final int minLine; // Set this to a value greater than 1 for a text area  
  double marginHorizontal;  
  var prefixIcon;  
  var suffixIcon;  

  TemplateTextFormV2(  
      {this.fieldKey,  
        this.hintText,  
        this.helperText,  
        this.labelText,  
        this.onSaved,  
        this.onChange,  
        this.validator,  
        this.controller,  
        this.enabled = true,  
        this.adaValidasi = false,  
        this.keyboardNumber = false,  
        this.titleText,  
        this.textCapitalization = TextCapitalization.words,  
        this.bottomMargin = 12.0,  
        this.maxLine = 5, // Increase maxLines for a text area  
        this.initialValue,  
        this.marginHorizontal = 0.0,  
        this.prefixIcon,  
        this.suffixIcon,  
        this.color = Colors.white,  
        this.flagColorBackground = false,  
        this.fontSize = 14,  
        this.radius = 16,  
        this.minLine = 3, // Minimum lines for a text area  
      });  

  @override  
  _TemplateTextFormV2State createState() => _TemplateTextFormV2State();  
}  

class _TemplateTextFormV2State extends State<TemplateTextFormV2> {  

  @override  
  Widget build(BuildContext context) {  
    return Container(  
      margin: EdgeInsets.only(bottom: widget.bottomMargin),  
      child: Container(  
        decoration: BoxDecoration(  
          borderRadius: BorderRadius.circular(widget.radius),  
          color: widget.enabled  
                  ? null  
                  : widget.flagColorBackground  
                    ? Colors.grey[50]  
                    : Colors.grey[300]  
        ),  
        child: Column(  
          children: [  
            TextFormField(  
              cursorColor: widget.color,  
              minLines: widget.minLine, // At least 3 lines shown  
              maxLines: widget.maxLine,  // Can extend up to 5 lines (or more)  
              controller: widget.controller,  
              key: widget.fieldKey,  
              keyboardType: widget.keyboardNumber ? TextInputType.number : TextInputType.multiline,  
              enabled: widget.enabled,  
              style: TextStyle(fontSize: widget.fontSize, color: widget.color),  
              decoration: InputDecoration(  
                  enabledBorder: UnderlineInputBorder(  
                    borderRadius: BorderRadius.circular(widget.radius),  
                    borderSide: BorderSide(  
                      color: CustomStyle.colorLineFormTextField,  
                    ),  
                  ),  
                  disabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),  
                  fillColor: Colors.transparent,  
                  filled: true,  
                  label: Row(  
                    children: [  
                      Text(widget.titleText!,  
                          style: TextStyle(fontSize: widget.fontSize + 1)),  
                      widget.adaValidasi  
                          ? Container(  
                              margin: EdgeInsets.only(left: 5),  
                              child: Text("*",  
                                  style: TextStyle(color: Colors.red,  
                                      fontWeight: FontWeight.bold,  
                                      fontSize: widget.fontSize + 2)))  
                          : Container(),  
                    ],  
                  ),  
                  prefixIcon: widget.prefixIcon,  
                  suffixIcon: widget.suffixIcon,  
                  contentPadding: EdgeInsets.fromLTRB(3, 2, 20.0, 7),  
              ),  
              onChanged: widget.onChange,  
            ),  
          ],  
        ),  
      ),  
    );  
  }  
}