import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class TemplateTextFormAkun extends StatefulWidget {
  final Key? fieldKey;
  final String? hintText;
  final String? labelText;
  final String? helperText;
  final String? titleText;
  var color;
  bool flagColorBackground;
  var initialValue;
  final double fontSize;
  final FormFieldSetter<String>? onSaved;
  final FormFieldSetter<String>? onChange;
  final FormFieldValidator<String>? validator;
  final TextEditingController? controller;
  final TextCapitalization textCapitalization;
  final bool enabled;
  final bool adaValidasi;
  final bool formater;
  final bool keyboardNumber;
  final double bottomMargin;
  final double radius;
  final int maxLine;
  final int minLine;
  double marginHorizontal;
  var prefixIcon;
  var suffixIcon;
  TemplateTextFormAkun(
      {this.fieldKey,
        this.hintText,
        this.helperText,
        this.labelText,
        this.onSaved,
        this.onChange,
        this.validator,
        this.formater = false,
        this.controller,
        this.enabled = true,
        this.adaValidasi = false,
        this.keyboardNumber = false,
        this.titleText,
        this.textCapitalization = TextCapitalization.words,
        this.bottomMargin = 12.0,
        this.maxLine = 1,
        this.initialValue,
        this.marginHorizontal = 0.0,
        this.prefixIcon,
        this.suffixIcon,
        this.color = Colors.white,
        this.flagColorBackground = false,
        this.fontSize = 14,
        this.radius = 16,
        this.minLine = 1,});
  @override
  _TemplateTextFormAkunState createState() => _TemplateTextFormAkunState();
}

class _TemplateTextFormAkunState extends State<TemplateTextFormAkun> {

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: widget.bottomMargin),
      child: Container(
        margin: EdgeInsets.only(left: widget.marginHorizontal, right: widget.marginHorizontal),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(widget.radius),
          color: widget.enabled
                  ? null
                  : widget.flagColorBackground
                    ? Colors.grey[50]
                    : Colors.grey[300]
        ),
        // height: 40,
        color: null,
        child: Column(
          children: [
            TextFormField(
              cursorColor: widget.color,
              minLines: widget.minLine,
              maxLines: widget.maxLine,
              controller: widget.controller,
              key: widget.fieldKey,
              keyboardType: widget.keyboardNumber ? TextInputType.number : TextInputType.text,
              inputFormatters: widget.formater
                  ? [
                      FilteringTextInputFormatter.allow(
                          RegExp(r'^\d+\.?\d{0,2}')),
                    ]
                  : [],
              enabled: widget.enabled,
              style: TextStyle(fontSize: widget.fontSize, color: widget.color),
              decoration: InputDecoration(
                  enabledBorder: UnderlineInputBorder(
                    borderRadius: BorderRadius.circular(widget.radius),
                    borderSide: BorderSide(
                      color: CustomStyle.colorLineFormTextField,
                    ),
                  ),
                  disabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),

                  // hintStyle: TextStyle(color: widget.enabled?widget.color:Colors.grey[600]),
                  // labelStyle: TextStyle(color: Colors.blue),

                  fillColor: Colors.transparent,
                  filled: true,
                  label:  Row(
                    children: [
                      Text(widget.titleText!,
                          style: TextStyle( fontSize: widget.titleText!.isEmpty?widget.fontSize+1:widget.fontSize+3)),
                      widget.adaValidasi
                          ? Container(
                              margin: EdgeInsets.only(left: 5),
                              child: Text("*",
                                  style: TextStyle(color:Colors.red, fontWeight: FontWeight.bold, fontSize: widget.fontSize+2)))
                          : Container(),
                    ],
                  ),
                  prefixIcon: widget.prefixIcon,
                  suffixIcon: widget.suffixIcon,
                  contentPadding: EdgeInsets.fromLTRB(3, 2, 20.0, 7),
                  // hintText: widget.hintText,

                  // labelText: widget.labelText
              ),
              onChanged: widget.onChange,
            ),
                // Align(
                //   alignment: Alignment.topRight,
                //   child: Text(widget.controller!.text,
                //       style: TextStyle(color: Colors.red, fontSize: widget.fontSize-1)),
                // ),
          ],
        ),
      ),
    );
  }
}



/*
import 'package:flutter/material.dart';

class TemplateTextFormAkun extends StatefulWidget {
  final Key? fieldKey;
  final String? hintText;
  final String? labelText;
  final String? helperText;
  final String? titleText;
  var color;
  bool flagColorBackground;
  var initialValue;
  final double fontSize;
  final FormFieldSetter<String>? onSaved;
  final FormFieldValidator<String>? validator;
  final TextEditingController? controller;
  final TextCapitalization textCapitalization;
  final bool enabled;
  final bool adaValidasi;
  final bool keyboardNumber;
  final double bottomMargin;
  final double radius;
  final int maxLine;
  final int minLine;
  var prefixIcon;
  var suffixIcon;
  TemplateTextFormAkun(
      {this.fieldKey,
        this.hintText,
        this.helperText,
        this.labelText,
        this.onSaved,
        this.validator,
        this.controller,
        this.enabled = true,
        this.adaValidasi = false,
        this.keyboardNumber = false,
        this.titleText,
        this.textCapitalization = TextCapitalization.words,
        this.bottomMargin = 12.0,
        this.maxLine = 1,
        this.initialValue,
        this.prefixIcon,
        this.suffixIcon,
        this.color = Colors.white,
        this.flagColorBackground = false,
        this.fontSize = 14,
        this.radius = 16,
        this.minLine = 1,});
  @override
  _TemplateTextFormAkunState createState() => _TemplateTextFormAkunState();
}

class _TemplateTextFormAkunState extends State<TemplateTextFormAkun> {

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: widget.bottomMargin),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          widget.titleText != null
              ? Padding(
            padding: const EdgeInsets.only(bottom: 8),
            child: Row(
              children: [
                Text(
                  widget.titleText!,
                  style: TextStyle(color: widget.color, fontWeight: FontWeight.bold, fontSize: widget.fontSize),
                ),
                widget.adaValidasi ?
                Container(
                  margin: EdgeInsets.only(left: 5),
                  child: Text(
                    "*",
                    style: TextStyle(color:Colors.red, fontWeight: FontWeight.bold, fontSize: widget.fontSize),
                  ),
                ): Container(),
              ],
            ),
          )
              : Container(),
          Container(
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(widget.radius),
                color: widget.enabled
                    ? null
                    : widget.flagColorBackground
                    ? Colors.grey[50]
                    : Colors.grey[300]
            ),
            height: 40,color: null,
            child: TextFormField(
              // validator: widget.adaValidasi == true ? _validate : null,
              cursorColor: widget.color,
              minLines: widget.minLine,
              maxLines: widget.maxLine,
              controller: widget.controller,
              key: widget.fieldKey,
              keyboardType: widget.keyboardNumber ? TextInputType.number : TextInputType.text,
              enabled: widget.enabled,
              style: TextStyle(fontSize: widget.fontSize, color: widget.color),
              decoration: InputDecoration(
                  enabledBorder: OutlineInputBorder(
                    borderRadius: BorderRadius.circular(widget.radius),
                    borderSide: BorderSide(
                      color: widget.color,
                      width: 0.8,
                    ),
                  ),
                  focusedBorder: OutlineInputBorder(
                    borderRadius: BorderRadius.circular(widget.radius),
                    borderSide: BorderSide(
                      color: widget.color,
                      width: 1,
                    ),
                  ),
                  disabledBorder: OutlineInputBorder(
                    borderRadius: BorderRadius.circular(widget.radius),
                    borderSide: BorderSide(
                      color: Colors.grey,
                      width: 1,
                    ),
                  ),
                  hintStyle: TextStyle(color: widget.enabled?widget.color:Colors.grey[600]),
                  labelStyle: TextStyle(color: widget.color),
                  fillColor: Colors.transparent,
                  filled: true,
                  prefixIcon: widget.prefixIcon,
                  suffixIcon: widget.suffixIcon,
                  contentPadding: EdgeInsets.fromLTRB(13.0, 12, 20.0, 12),
                  hintText: widget.hintText,
                  labelText: widget.labelText),
            ),
          ),
        ],
      ),
    );
  }
}
*/