import 'package:flutter/material.dart';

class TemplateTextFieldForm extends StatefulWidget {
  final Key? fieldKey;
  final String? hintText;
  final String? labelText;
  final String? helperText;
  final String? titleText;
  var color;
  var initialValue;
  final double fontSize;
  final FormFieldSetter<String>? onSaved;
  final FormFieldValidator<String>? validator;
  final TextEditingController? controller;
  final TextCapitalization textCapitalization;
  final bool enabled;
  final bool adaValidasi;
  final bool keyboardNumber;
  final double bottomMargin;
  final double radius;
  final int maxLine;
  final int minLine;
  var prefixIcon;
  TemplateTextFieldForm(
      {this.fieldKey,
      this.hintText,
      this.helperText,
      this.labelText,
      this.onSaved,
      this.validator,
      this.controller,
      this.enabled = true,
      this.adaValidasi = false,
      this.keyboardNumber = false,
      this.titleText,
      this.textCapitalization = TextCapitalization.words,
      this.bottomMargin = 12.0,
      this.maxLine = 1,
        this.initialValue,
      this.prefixIcon,
      this.color = Colors.white,
      this.fontSize = 14,
      this.radius = 16,
        this.minLine = 1,});
  @override
  _TemplateTextFieldFormState createState() => _TemplateTextFieldFormState();
}

class _TemplateTextFieldFormState extends State<TemplateTextFieldForm> {
  String? _validate(String? value) {
    if (value!.isEmpty) return 'Please fill this form.';
    return null;
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: widget.bottomMargin),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          widget.titleText != null
              ? Padding(
                padding: const EdgeInsets.only(bottom: 8),
                child: Text(
                    widget.titleText!,
                    style: TextStyle(color: widget.color, fontWeight: FontWeight.bold, fontSize: widget.fontSize),
                  ),
              )
              : Container(),
          TextFormField(
            validator: widget.adaValidasi == true ? _validate : null,
            cursorColor: widget.color,
            minLines: widget.minLine,
            maxLines: widget.maxLine,
            controller: widget.controller,
            key: widget.fieldKey,
            enabled: widget.enabled,
            style: TextStyle(fontSize: widget.fontSize, color: widget.color),
            decoration: InputDecoration(
                enabledBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide: BorderSide(
                    color: widget.color,
                    width: 0.8,
                  ),
                ),
                focusedBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide: BorderSide(
                    color: widget.color,
                    width: 1,
                  ),
                ),
                disabledBorder: OutlineInputBorder(
                  borderRadius: BorderRadius.circular(widget.radius),
                  borderSide: BorderSide(
                    color: Colors.grey,
                    width: 0.8,
                  ),
                ),
                hintStyle: TextStyle(color: widget.enabled?widget.color:Colors.grey[600]),
                labelStyle: TextStyle(color: widget.color),
                fillColor: Colors.transparent,
                filled: true,
                prefixIcon: widget.prefixIcon,
                contentPadding: EdgeInsets.fromLTRB(20.0, 12, 20.0, 12),
                hintText: widget.hintText,
                labelText: widget.labelText),
          ),
        ],
      ),
    );
  }
}
