// selected_id_bloc.dart

import 'package:flutter_bloc/flutter_bloc.dart';

// Define events
abstract class SelectedIdEvent {}

class UpdateSelectedIdEvent extends SelectedIdEvent {
  final String idSelected;
  UpdateSelectedIdEvent(this.idSelected);
}

// Define states
abstract class SelectedIdState {}

class SelectedIdInitial extends SelectedIdState {}

class SelectedIdUpdated extends SelectedIdState {
  final String idSelected;
  SelectedIdUpdated(this.idSelected);
}

// Implement the Bloc
class SelectedIdBloc extends Bloc<SelectedIdEvent, SelectedIdState> {
  SelectedIdBloc() : super(SelectedIdInitial());

  @override
  Stream<SelectedIdState> mapEventToState(SelectedIdEvent event) async* {
    if (event is UpdateSelectedIdEvent) {
      yield SelectedIdUpdated(event.idSelected);
    }
  }
}
