import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownEvent {}

class SelectDataKaryawan extends DropdownEvent {
  DataDropdown? selectedValue;
  SelectDataKaryawan(this.selectedValue);
}

abstract class KaryawanSelectedState {}

class KaryawanSelectedInitial extends KaryawanSelectedState {}

class KaryawanSelectedSuccessState extends KaryawanSelectedState {
  DataDropdown? selectedValue;
  KaryawanSelectedSuccessState(this.selectedValue);
}

class DropdownErrorState extends KaryawanSelectedState {}

class KaryawanSelectedBloc extends Bloc<DropdownEvent, KaryawanSelectedState> {
  DataDropdown? selectedValue;
  KaryawanSelectedBloc(KaryawanSelectedState initialState) : super(initialState);
  @override
  Stream<KaryawanSelectedState> mapEventToState(DropdownEvent event) async* {
    if (event is SelectDataKaryawan) {
      selectedValue = event.selectedValue;
      yield KaryawanSelectedSuccessState(selectedValue);
    }
  }
}
