import 'dart:io';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePicker2Bloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel2.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class TemplateMultiImagePicker2 extends StatefulWidget {
  var borderColor;
  final double bottomMargin;
  final bool multiImage;
  final bool fromCamera;
  final String defaultCamera;
  final String pluginCamera;
  List<String>? initialData;
  TemplateMultiImagePicker2({this.initialData, this.borderColor, this.bottomMargin = 12, this.multiImage = true, this.fromCamera = false, this.defaultCamera='front', this.pluginCamera='1'});
  @override
  _TemplateMultiImagePicker2State createState() => _TemplateMultiImagePicker2State();
}

class _TemplateMultiImagePicker2State extends State<TemplateMultiImagePicker2> {
  int countImage = 0;

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: widget.bottomMargin),
      child: ConstrainedBox(constraints: BoxConstraints(
        minHeight: 180,
        minWidth: MediaQuery.of(context).size.width
      ),
      child: Container(
        padding: EdgeInsets.only(top: 16, bottom: 16),
        decoration: BoxDecoration(
            color: Colors.white,
            border: Border.all(
                width: 0.8,
                color: widget.borderColor!=null?widget.borderColor:Colors.grey[600]),
            borderRadius:
            new BorderRadius.all(Radius.circular(8))),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            BlocBuilder<MultiImagePicker2Bloc, MultiImagePicker2State>(
              builder: (BuildContext context, MultiImagePicker2State state){
                if(state is MultiImageSuccess2State){
                  return Container(
                    margin: EdgeInsets.only(bottom: 18),
                    child: state.listData!=null&&state.listData.length>0?widget.multiImage?Wrap(
                      spacing: 6,
                      runSpacing: 4,
                      children: state.listData
                          .map((item) => ImageCard(item))
                          .toList(),
                    ):Column(
                      children: [
                        Container(
                          padding: EdgeInsets.all(6),
                          child: Stack(
                            children: [
                              Image.file(File(state.listData[0].path)),
                              Align(
                                alignment: Alignment.topRight,
                                child: GestureDetector(
                                  onTap: ()=>BlocProvider.of<MultiImagePicker2Bloc>(context).add(DeleteImage2(state.listData[0])),
                                  child: Container(
                                    margin: EdgeInsets.fromLTRB(0, 5, 5, 0),
                                    decoration: BoxDecoration(
                                      shape: BoxShape.circle,
                                      color: Colors.white,
                                    ),
                                      child: Icon(Icons.close)),
                                ),
                              )
                            ],
                          ),
                        ),
                        widget.multiImage?Container():SizedBox(height: 15),
                        widget.multiImage?Container():
                            state.listData.length > 0
                              ? Container()
                              : TemplateButton(
                                  onClick: ()=>BlocProvider.of<MultiImagePicker2Bloc>(context).add(widget.multiImage?PickImage2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera):PickImageSingle2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera)),
                                  label: widget.fromCamera?"Ambil Foto":"Ambil Gambar", color: Colors.grey[100], borderColor: Colors.grey[500], radius: CustomStyle.boxRadius, contentColor: Colors.grey[500], paddingLeftRight: 8, heightButton: 32, paddingTopBottom: 0, icon: Icons.add,)
                      ],
                    ):TemplateButton(
                      onClick: ()=>BlocProvider.of<MultiImagePicker2Bloc>(context).add(widget.multiImage?PickImage2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera):PickImageSingle2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera)),
                      label: widget.fromCamera?"Ambil Foto":"Ambil Gambar", color: Colors.grey[100], borderColor: Colors.grey[500], radius: CustomStyle.boxRadius, contentColor: Colors.grey[500], paddingLeftRight: 8, heightButton: 32, paddingTopBottom: 0, icon: Icons.add,),
                  );
                }
                else if(widget.initialData!=null)return Container(
                    margin: EdgeInsets.only(bottom: 18),
                    child: widget.initialData!.length>1?Wrap(
                      spacing: 6,
                      runSpacing: 4,
                      children: widget.initialData!
                          .map((item) => Image.network(item))
                          .toList(),
                    ):Container(
                      padding: EdgeInsets.all(6),
                      child: Stack(
                        children: [
                          Image.network(widget.initialData![0], errorBuilder: (c,obj,st){
                            return Icon(Icons.image_not_supported_outlined);
                          }),
                          Align(
                            alignment: Alignment.topRight,
                            child: GestureDetector(
                              onTap: ()=>BlocProvider.of<MultiImagePicker2Bloc>(context).add(DeleteImage2(MultiImagePickerModel2('',''))),
                              // onTap: (){
                              //   setState(() {
                              //     widget.initialData = null;
                              //     print("wonten mriki");
                              //   });
                              // },
                              child: Container(
                                  margin: EdgeInsets.fromLTRB(0, 5, 5, 0),
                                  decoration: BoxDecoration(
                                    shape: BoxShape.circle,
                                    color: Colors.white,
                                  ),
                                  child: Icon(Icons.close)),
                            ),
                          )
                        ],
                      )));
                else return widget.multiImage==true?Container():
                  TemplateButton(
                    onClick: ()=>BlocProvider.of<MultiImagePicker2Bloc>(context).add(widget.multiImage?PickImage2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera):PickImageSingle2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera)),
                    label: widget.fromCamera?"Ambil Foto":"Ambil Gambar", color: Colors.grey[100], borderColor: Colors.grey[500], radius: CustomStyle.boxRadius, contentColor: Colors.grey[500], paddingLeftRight: 8, heightButton: 32, paddingTopBottom: 0, icon: Icons.add,);
              },
            ),
            widget.multiImage==false ? Container() :
            TemplateButton(
              onClick: ()=>BlocProvider.of<MultiImagePicker2Bloc>(context).add(widget.multiImage?PickImage2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera):PickImageSingle2(context, fromCamera: widget.fromCamera, defaultCamera: widget.defaultCamera, pluginCamera: widget.pluginCamera)),
              label: widget.fromCamera?"Ambil Foto":"Ambil Gambar", color: Colors.grey[100], borderColor: Colors.grey[500], radius: CustomStyle.boxRadius, contentColor: Colors.grey[500], paddingLeftRight: 8, heightButton: 32, paddingTopBottom: 0, icon: Icons.add,),
          ],
        ),
      ),),
    );
  }
  Widget ImageCard(MultiImagePickerModel2 image){
    return Stack(
        children: [
      Image.file(File(image.path), width: MediaQuery.of(context).size.width/4,),
      Positioned(
          right: 0,
          top: 0,
          child: TemplateButton(
            onClick: ()=>BlocProvider.of<MultiImagePicker2Bloc>(context).add(DeleteImage2(image)),
            label: 'x', color: Colors.transparent, contentColor: Colors.redAccent, paddingLeftRight: 6, fontSize: CustomStyle.fontSizeTitle, bold: true,))
        ],
    );
  }
}
