import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart' as dateRangePicker;
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:month_picker_dialog/month_picker_dialog.dart';

// ignore: must_be_immutable
class TemplateMonthPickerNonFloating extends StatefulWidget {
  DateTime? initialData;
  double height;
  bool lastMonth;
  TemplateMonthPickerNonFloating({this.initialData, this.height = 46, this.lastMonth = false});

  @override
  _TemplateMonthPickerNonFloatingState createState() => _TemplateMonthPickerNonFloatingState();
}

class _TemplateMonthPickerNonFloatingState extends State<TemplateMonthPickerNonFloating> {
  DateTime selectedDate = DateTime.now();
  final dateFormat = new DateFormat('MM-yyyy');

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    if(widget.initialData!=null) BlocProvider.of<MonthPickerBloc>(context).add(SetDate(widget.initialData));
    /*else BlocProvider.of<MonthPickerBloc>(context).add(SetDate(DateTime.now()));*/
    /*if(widget.initialData!=null){
      DateTime todayDate = DateTime.parse(widget);
    }*/
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot){
          return 
          BlocBuilder<MonthPickerBloc, MonthPickerState>(
            builder: (BuildContext context, MonthPickerState state){
              if(state is ChangeMonthSuccessState)
                return GestureDetector(
                  onTap: () async{
                    BlocProvider.of<dateRangePicker.DateRangePickerBloc>(context).add(dateRangePicker.InitialDate());
                    final DateTime? picked = await showMonthPicker(
                        locale: Locale(snapshot.data??'en'),
                        context: context,
                        cancelWidget: Text(snapshot.data==null || snapshot.data=="en"?"Cancel":"Batal"),
                        confirmWidget: Text(snapshot.data==null || snapshot.data=="en"?"Apply":"Terapkan"),
                        initialDate: state.dateTime!=null?state.dateTime!:DateTime.now(),
                        firstDate: DateTime(2015, 8),
                        lastDate: widget.lastMonth?DateTime(DateTime.now().year, DateTime.now().month):DateTime(2101));
                    if (picked != null && picked != selectedDate) BlocProvider.of<MonthPickerBloc>(context).add(SetDate(picked));
                  },
                  child: Container(
                    padding: EdgeInsets.fromLTRB(16, 7, 16, 7),
                    decoration: BoxDecoration(
                        boxShadow: [
                          BoxShadow(
                            color: Colors.grey.withOpacity(0.3),
                            spreadRadius: 2,
                            blurRadius: 5,
                            offset: Offset(0, 1), // changes position of shadow
                          ),
                        ],
                        gradient: LinearGradient(
                            begin: Alignment.centerLeft,
                            end: Alignment.centerRight,
                            stops: [ 0.0,0.5,1.0],
                            colors: [
                              Colors.orange[500]!,
                              Colors.orange[300]!,
                              Colors.orange[500]!,
                            ]),
                        borderRadius: new BorderRadius.all(
                          Radius.circular(20),
                        )),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        Text(snapshot.data == null ? "Month - Year" : snapshot.data == "en" ? "Month - Year" : "Bulan - Tahun", style: TextStyle(color: Colors.white, fontWeight: FontWeight.w600, fontSize: CustomStyle.fontSizeSmall),),
                        SizedBox(height: 1,),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            SizedBox(width: 8,),
                            Text(state.dateTime!=null?dateFormat.format(state.dateTime!):'-', style: TextStyle(fontSize: CustomStyle.fontSizeSmall-1, color: Colors.white),),
                            SizedBox(width: 4,),
                            Icon(Icons.keyboard_arrow_down, color: Colors.white,  size: 18)
                          ],
                        ),
                      ],
                    ),
                  ),
                );
              else return Container();
            },
          );
        }
    );
  }
}
