import 'dart:async';

import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:lottie/lottie.dart';

class ProgressDialogDelayed {
  static Timer? _timer;
  static BuildContext? _currentContext;

  static void show(
    ProgressDialog pd, {
    bool isDismissible = false,
    Duration delay = const Duration(milliseconds: 300),
  }) {
    _currentContext = pd.context;
    _timer?.cancel(); // Cancel any existing timer
    _timer = Timer(delay, () {
      if (_currentContext != null && _currentContext!.mounted) {
        showGeneralDialog(
          context: _currentContext!,
          barrierDismissible: isDismissible,
          barrierLabel: "Progress",
          barrierColor: Colors.transparent, // No dark background
          transitionDuration: const Duration(milliseconds: 150),
          pageBuilder: (context, animation, secondaryAnimation) {
            return pd;
          },
        );
      }
    });
  }

  static void hide(ProgressDialog pd) {
    _timer?.cancel();
    _timer = null;
    if (_currentContext != null && _currentContext!.mounted) {
      Navigator.of(_currentContext!).pop();
    }
    _currentContext = null;
  }
}

class ProgressDialog extends StatelessWidget {
  final Widget? child;
  final BuildContext context;

  const ProgressDialog({
    required this.context,
    this.child,
    Key? key,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return child ?? const DefaultProgressDialog();
  }
}

class DefaultProgressDialog extends StatelessWidget {
  const DefaultProgressDialog({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Lottie.asset(
        'assets/loading.json',
        width: 300,
        height: 300,
        repeat: true,
      ),
    );
  }
}
class showSnackBarDelayed {
  showSnackBarDelayed(GlobalKey<ScaffoldState>? key,  message, BuildContext? context, {Color? backgroundColor, Color? textColor}) {
    ScaffoldMessenger.of(context!).showSnackBar(
        SnackBar(backgroundColor : backgroundColor==null?CustomStyle.color1:backgroundColor,content: Text(message, style: TextStyle(color: textColor==null?Colors.white:textColor, fontWeight: FontWeight.bold),)));
  }
}

