// import 'dart:async';
// import 'dart:convert';
// import 'dart:io';
//
// import 'package:absenkuv3/Bloc/AuthBloc.dart';
// import 'package:absenkuv3/Bloc/CustomFunction.dart';
// import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
// import 'package:absenkuv3/Repository/Model/mFace.dart';
// import 'package:absenkuv3/Repository/Model/mLogin.dart';
// import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
// import 'package:absenkuv3/Repository/Service/FaceRecognitionApi.dart';
// import 'package:absenkuv3/Repository/Service/userApi.dart';
// import 'package:absenkuv3/Repository/sharedPreference.dart';
// import 'package:absenkuv3/UI/Template/FaceRecognition/services/facenet.service.dart';
// import 'package:absenkuv3/UI/Template/FaceRecognition/services/ml_vision_service.dart';
// import 'package:camera/camera.dart';
// import 'package:flutter/material.dart';
// import 'package:flutter_bloc/flutter_bloc.dart';
// import 'package:flutter_image_compress/flutter_image_compress.dart';
// import 'package:google_ml_kit/google_ml_kit.dart';
// import 'package:path_provider/path_provider.dart' as path_provider;
//
// import '../../style.dart';
//
// abstract class FaceRegistrationEvent{
//   BuildContext? context;
//   GlobalKey<ScaffoldState>? scaffoldKey;
// }
//
// class Initialize extends FaceRegistrationEvent{
//   Initialize(BuildContext? _context){
//     context = _context;
//   }
// }
//
// class Dispose extends FaceRegistrationEvent{
//   Dispose(BuildContext _context){
//     context = _context;
//   }
// }
//
// class FrameFaces extends FaceRegistrationEvent{}
//
// class TakePicture extends FaceRegistrationEvent{
//   TakePicture(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey){
//     context = _context;
//     scaffoldKey = _scaffoldKey;
//   }
// }
//
//
// abstract class FaceRegistrationState{
//   CameraController? controller;
//   Face? faceDetected;
//   Size? imageSize;
// }
//
// class InitializeProgress extends FaceRegistrationState{}
//
// class InitializeSuccess extends FaceRegistrationState{
//   InitializeSuccess(CameraController? _controller, Face? _faceDetected, Size? _imageSize){
//     controller = _controller;
//     faceDetected = _faceDetected;
//     imageSize = _imageSize;
//   }
// }
//
// class TakePictureSuccess extends FaceRegistrationState{
//   XFile file;
//   TakePictureSuccess(this.file);
// }
//
//
// class FaceRegistrationBloc extends Bloc<FaceRegistrationEvent, FaceRegistrationState>{
//   late List<CameraDescription> cameras;
//   CameraController? controller;
//   late XFile file;
//   int? cameraId;
//   Size? imageSize;
//   MLVisionService _mlVisionService = MLVisionService();
//   final FaceNetService _faceNetService = FaceNetService();
//   Face? faceDetected;
//   bool _detectingFaces = false;
//   late InputImageRotation _inputImageRotation;
//   late CameraImage image;
//   bool firstInit = true;
//
//   FaceRegistrationBloc(FaceRegistrationState initialState) : super(initialState);
//
//   InputImageRotation rotationIntToImageRotation(int rotation) {
//     switch (rotation) {
//       case 90:
//         return InputImageRotation.Rotation_90deg;
//       case 180:
//         return InputImageRotation.Rotation_180deg;
//       case 270:
//         return InputImageRotation.Rotation_270deg;
//       default:
//         return InputImageRotation.Rotation_0deg;
//     }
//   }
//
//   @override
//   Stream<FaceRegistrationState> mapEventToState(FaceRegistrationEvent event) async*{
//     // TODO: implement mapEventToState
//     if(event is Initialize){
//       FaceRegistrationInfoRespon faceRegistrationInfoRespon = await FaceRecognitionApi().getDataPeringatanRegistrasi();
//       if(faceRegistrationInfoRespon.success! && firstInit){
//         CustomPopUpRegistrasiWajah.show(faceRegistrationInfoRespon.data, event.context);
//         firstInit = false;
//       }
//       _mlVisionService.initialize();
//       await _faceNetService.loadModel();
//       yield InitializeProgress();
//       cameras = await availableCameras();
//       CameraDescription cameraDescription = cameras.firstWhere(
//             (CameraDescription camera) => camera.lensDirection == CameraLensDirection.front,
//       );
//       controller = new CameraController(cameraDescription, ResolutionPreset.high, enableAudio: false);
//       await controller!.initialize();
//
//       // sets the rotation of the image
//       this._inputImageRotation = rotationIntToImageRotation(
//         cameraDescription.sensorOrientation,
//       );
//
//       imageSize = Size(
//         controller!.value.previewSize!.height,
//         controller!.value.previewSize!.width,
//       );
//
//       startStream(event.context);
//
//       yield InitializeSuccess(controller, faceDetected, imageSize);
//     }
//     else if(event is FrameFaces){
//       yield InitializeSuccess(controller, faceDetected, imageSize);
//     }
//     else if(event is TakePicture){
//       await controller!.stopImageStream();
//       yield InitializeProgress();
//       if (!controller!.value.isInitialized) {
//         print('Error: select a camera first.');
//       }
//       if (!controller!.value.isTakingPicture) {
//         try {
//           if (faceDetected!=null) {
//             await controller!.setFocusMode(FocusMode.locked);
//             await Future.delayed(Duration(milliseconds: 500));
//             file = await controller!.takePicture();
//             final dir = await path_provider.getTemporaryDirectory();
//             File fileCompressed = await testCompressAndGetFile(File(file.path), "${dir.absolute.path}/${DateTime.now()}.jpg");
//             await _faceNetService.setCurrentPrediction(image, faceDetected!);
//             List? predictedData = _faceNetService.predictedData;
//                 BasicRespon basicRespon = await UserApi().faceRegistration(predictedData, base64Encode(fileCompressed.readAsBytesSync()));
//             if(basicRespon.success!){
//               faceDetected = null;
//               // LoginRespon loginRespon = await sharedPreferences().getUserData();
//               // loginRespon.dataLogin.faceData = predictedData.toString();
//               // await sharedPreferences().setUserData(loginRespon);
//               BlocProvider.of<AuthBloc>(event.context!)
//                   .add(GetUserDataTerkiniEvent(event.context, event.scaffoldKey));
//               CustomPopUp.show(basicRespon.message, event.context, isDismissible: false, doublePop: true);
//             }
//           }
//           else{
//             faceDetected = null;
//             CustomPopUp.show("Wajah tidak terdeteksi", event.context, isDismissible: false, doublePop: false, icon: Icon(Icons.close, color: Colors.redAccent, size: 46,), color: Colors.redAccent);
//             BlocProvider.of<FaceRegistrationBloc>(event.context!).add(Initialize(event.context));
//           }
//         } on CameraException catch (e) {
//           startStream(event.context);
//           print('ERROR $e');
//         }
//       }
//       else print('ERROR');
//     }
//     else if(event is Dispose){
//       print('DISPOSE');
//       await controller!.dispose();
//       BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
//     }
//
//   }
//
//   startStream(BuildContext? context){
//     controller!.startImageStream((_image) async {
//       if (controller != null) {
//         // if its currently busy, avoids overprocessing
//         if (_detectingFaces) return;
//         _detectingFaces = true;
//         try {
//           List<Face> faces = await _mlVisionService.getFacesFromImage(_image, _inputImageRotation);
//           if (faces != null) {
//             if (faces.length > 0) {
//               // preprocessing the image
//               faceDetected = faces[0];
//               image = _image;
//             } else {
//               faceDetected = null;
//             }
//           }
//           _detectingFaces = false;
//         } catch (e) {
//           print(e);
//           _detectingFaces = false;
//         }
//         BlocProvider.of<FaceRegistrationBloc>(context!).add(FrameFaces());
//       }
//     });
//   }
//
//   Future<File> testCompressAndGetFile(File file, String targetPath) async {
//     var result = await FlutterImageCompress.compressAndGetFile(
//       file.absolute.path, targetPath,
//       quality: 75,
//     );
//
//     print(file.lengthSync());
//     print(result!.lengthSync());
//
//     return result;
//   }
//
// }