import 'dart:async';
import 'dart:convert';
import 'dart:io';
import 'dart:typed_data';
import 'package:absenkuv3/Repository/Model/PageModel/mButtonPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:google_mlkit_face_detection/google_mlkit_face_detection.dart';
import 'package:image/image.dart' as imglib;
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFace.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/FaceRecognitionApi.dart';
import 'package:absenkuv3/Repository/Service/userApi.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/UI/Template/FaceRecognition/services/facenet.service.dart';
import 'package:absenkuv3/UI/Template/FaceRecognition/services/ml_vision_service.dart';
import 'package:camera/camera.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_image_compress/flutter_image_compress.dart';
import 'package:image/image.dart';
import 'package:path_provider/path_provider.dart' as path_provider;

import '../../style.dart';

abstract class FaceRegistrationEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class Initialize extends FaceRegistrationEvent {
  String? title;
  String? btnLabel;
  Initialize(BuildContext? _context, String? _title, String? _btnLabel) {
    context = _context;
    title = _title;
    btnLabel = _btnLabel;
  }
}

class Dispose extends FaceRegistrationEvent {
  Dispose(BuildContext _context) {
    context = _context;
  }
}

class FrameFaces extends FaceRegistrationEvent {}

class TakePicture extends FaceRegistrationEvent {
  TakePicture(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

abstract class FaceRegistrationState {
  CameraController? controller;
  Face? faceDetected;
  Size? imageSize;
}

class InitializeProgress extends FaceRegistrationState {}

class InitializeSuccess extends FaceRegistrationState {
  InitializeSuccess(
      CameraController? _controller, Face? _faceDetected, Size? _imageSize) {
    controller = _controller;
    faceDetected = _faceDetected;
    imageSize = _imageSize;
  }
}

class TakePictureSuccess extends FaceRegistrationState {
  XFile file;
  TakePictureSuccess(this.file);
}

class FaceRegistrationBloc
    extends Bloc<FaceRegistrationEvent, FaceRegistrationState> {
  late List<CameraDescription> cameras;
  CameraController? controller;
  late XFile file;
  int? cameraId;
  Size? imageSize;
  MLVisionService _mlVisionService = MLVisionService();
  final FaceNetService _faceNetService = FaceNetService();
  Face? faceDetected;
  bool _detectingFaces = false;
  late InputImageRotation _inputImageRotation;
  late CameraImage image;
  bool firstInit = true;

  FaceRegistrationBloc(FaceRegistrationState initialState)
      : super(initialState);

  InputImageRotation rotationIntToImageRotation(int rotation) {
    switch (rotation) {
      case 90:
        return InputImageRotation.rotation90deg;
      case 180:
        return InputImageRotation.rotation180deg;
      case 270:
        return InputImageRotation.rotation270deg;
      default:
        return InputImageRotation.rotation0deg;
    }
  }

  @override
  Stream<FaceRegistrationState> mapEventToState(
      FaceRegistrationEvent event) async* {
    // TODO: implement mapEventToState
    if (event is Initialize) {
      FaceRegistrationInfoRespon faceRegistrationInfoRespon =
          await FaceRecognitionApi().getDataPeringatanRegistrasi();
      if (faceRegistrationInfoRespon.success! && firstInit) {
        CustomPopUpRegistrasiWajah.show(faceRegistrationInfoRespon.data,
            event.context, event.title, event.btnLabel);
        firstInit = false;
      }
      _mlVisionService.initialize();
      await _faceNetService.loadModel();
      yield InitializeProgress();
      cameras = await availableCameras();
      CameraDescription cameraDescription = cameras.firstWhere(
        (CameraDescription camera) =>
            camera.lensDirection == CameraLensDirection.front,
      );
      controller = new CameraController(
          cameraDescription, ResolutionPreset.high,
          enableAudio: false);
      await controller!.initialize();

      // sets the rotation of the image
      this._inputImageRotation = rotationIntToImageRotation(
        cameraDescription.sensorOrientation,
      );

      imageSize = Size(
        controller!.value.previewSize!.height,
        controller!.value.previewSize!.width,
      );
      startStream(event.context);

      yield InitializeSuccess(controller, faceDetected, imageSize);
    } else if (event is FrameFaces) {
      yield InitializeSuccess(controller, faceDetected, imageSize);
    } else if (event is TakePicture) {
      await controller!.stopImageStream();
      yield InitializeProgress();
      if (!controller!.value.isInitialized) {
        debugPrint('Error: select a camera first.');
      }
      if (!controller!.value.isTakingPicture) {
        try {
          await controller!.setFocusMode(FocusMode.locked);
          await Future.delayed(Duration(milliseconds: 500));
          file = await controller!.takePicture();
          File files = File(file.path);
          List<dynamic> faces = await _mlVisionService.getFacesFromFile(files);
          // print("FACES ${faces.length}");
          if (faces != null) {
            if (faces.length > 0) {
              // preprocessing the image
              faceDetected = faces[0];
            } else {
              faceDetected = null;
            }
          }
          _detectingFaces = false;
          PageButtonModel? button;
          PengaturanBahasa().button().then((value) => button = value);
          print("pppppp : $button");
          List<int> imageBase64 = files.readAsBytesSync();
          Uint8List imageBytes = Uint8List.fromList(imageBase64);
          imglib.Image? imagelib = JpegDecoder().decode(imageBytes);
          final dir = await path_provider.getTemporaryDirectory();
          File fileCompressed = await testCompressAndGetFile(
              File(file.path), "${dir.absolute.path}/${DateTime.now()}.jpg");
          await _faceNetService.setCurrentPrediction(imagelib!, faceDetected!);
          List? predictedData = _faceNetService.predictedData;
          BasicRespon basicRespon = await UserApi().faceRegistration(
              predictedData, base64Encode(fileCompressed.readAsBytesSync()));
          if (basicRespon.success!) {
            faceDetected = null;
            // LoginRespon loginRespon = await sharedPreferences().getUserData();
            // loginRespon.dataLogin.faceData = predictedData.toString();
            // await sharedPreferences().setUserData(loginRespon);
            BlocProvider.of<AuthBloc>(event.context!)
                .add(GetUserDataTerkiniEvent(event.context, event.scaffoldKey));
            CustomPopUpShiftLepas.show(
                basicRespon.message, event.context, button!.button!.btnTutup,
                doublePop: false, isDismissible: false, closeCustom: () {
              BlocProvider.of<NavigatorBloc>(event.context!)
                  .add(NavigateToAbsensiReplace(event.context!));
            });
            // CustomPopUp.show(basicRespon.message, event.context, button!.button!.btnTutup, isDismissible: false, doublePop: true);
          }
        } on CameraException catch (e) {
          startStream(event.context);
          // print('ERROR $e');
        }
      } else
        debugPrint('ERROR');
    } else if (event is Dispose) {
      // print('DISPOSE');
      await controller!.dispose();
      BlocProvider.of<NavigatorBloc>(event.context!)
          .add(NavigatePop(event.context));
    }
  }

  startStream(BuildContext? context) {
    controller!.startImageStream((_image) async {
      if (controller != null) {
        // if its currently busy, avoids overprocessing
        if (_detectingFaces) return;
        _detectingFaces = true;
        try {
          List<dynamic> faces = await _mlVisionService.getFacesFromImage(
              _image, _inputImageRotation);
          if (faces != null) {
            if (faces.length > 0) {
              // preprocessing the image
              faceDetected = faces[0];
              image = _image;
            } else {
              faceDetected = null;
            }
          }
          _detectingFaces = false;
        } catch (e) {
          // print(e);
          _detectingFaces = false;
        }
        BlocProvider.of<FaceRegistrationBloc>(context!).add(FrameFaces());
      }
    });
  }

  Future<File> testCompressAndGetFile(File file, String targetPath) async {
    final result = await FlutterImageCompress.compressAndGetFile(
      file.absolute.path,
      targetPath,
      quality: 75,
    );

    if (result == null) {
      throw Exception('Compression failed');
    }

    print(file.lengthSync());

    // Convert XFile to File
    return File(result.path);
  }
}
